@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.InstanceInstanceMarketOptionsSpotOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property instanceInterruptionBehavior The behavior when a Spot Instance is interrupted. Valid values include `hibernate`, `stop`, `terminate` . The default is `terminate`.
 * @property maxPrice The maximum hourly price that you're willing to pay for a Spot Instance.
 * @property spotInstanceType The Spot Instance request type. Valid values include `one-time`, `persistent`. Persistent Spot Instance requests are only supported when the instance interruption behavior is either hibernate or stop. The default is `one-time`.
 * @property validUntil The end date of the request, in UTC format (YYYY-MM-DDTHH:MM:SSZ). Supported only for persistent requests.
 */
public data class InstanceInstanceMarketOptionsSpotOptionsArgs(
    public val instanceInterruptionBehavior: Output<String>? = null,
    public val maxPrice: Output<String>? = null,
    public val spotInstanceType: Output<String>? = null,
    public val validUntil: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.InstanceInstanceMarketOptionsSpotOptionsArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.InstanceInstanceMarketOptionsSpotOptionsArgs =
        com.pulumi.aws.ec2.inputs.InstanceInstanceMarketOptionsSpotOptionsArgs.builder()
            .instanceInterruptionBehavior(instanceInterruptionBehavior?.applyValue({ args0 -> args0 }))
            .maxPrice(maxPrice?.applyValue({ args0 -> args0 }))
            .spotInstanceType(spotInstanceType?.applyValue({ args0 -> args0 }))
            .validUntil(validUntil?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceInstanceMarketOptionsSpotOptionsArgs].
 */
@PulumiTagMarker
public class InstanceInstanceMarketOptionsSpotOptionsArgsBuilder internal constructor() {
    private var instanceInterruptionBehavior: Output<String>? = null

    private var maxPrice: Output<String>? = null

    private var spotInstanceType: Output<String>? = null

    private var validUntil: Output<String>? = null

    /**
     * @param value The behavior when a Spot Instance is interrupted. Valid values include `hibernate`, `stop`, `terminate` . The default is `terminate`.
     */
    @JvmName("rauvdxypucbjskle")
    public suspend fun instanceInterruptionBehavior(`value`: Output<String>) {
        this.instanceInterruptionBehavior = value
    }

    /**
     * @param value The maximum hourly price that you're willing to pay for a Spot Instance.
     */
    @JvmName("kwgsfwqbkqjfgtjw")
    public suspend fun maxPrice(`value`: Output<String>) {
        this.maxPrice = value
    }

    /**
     * @param value The Spot Instance request type. Valid values include `one-time`, `persistent`. Persistent Spot Instance requests are only supported when the instance interruption behavior is either hibernate or stop. The default is `one-time`.
     */
    @JvmName("qdphphrfxjcqrmxw")
    public suspend fun spotInstanceType(`value`: Output<String>) {
        this.spotInstanceType = value
    }

    /**
     * @param value The end date of the request, in UTC format (YYYY-MM-DDTHH:MM:SSZ). Supported only for persistent requests.
     */
    @JvmName("iobmpifpjggsoifq")
    public suspend fun validUntil(`value`: Output<String>) {
        this.validUntil = value
    }

    /**
     * @param value The behavior when a Spot Instance is interrupted. Valid values include `hibernate`, `stop`, `terminate` . The default is `terminate`.
     */
    @JvmName("saxushmhunroplit")
    public suspend fun instanceInterruptionBehavior(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceInterruptionBehavior = mapped
    }

    /**
     * @param value The maximum hourly price that you're willing to pay for a Spot Instance.
     */
    @JvmName("fgqkvirspvaduhbk")
    public suspend fun maxPrice(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxPrice = mapped
    }

    /**
     * @param value The Spot Instance request type. Valid values include `one-time`, `persistent`. Persistent Spot Instance requests are only supported when the instance interruption behavior is either hibernate or stop. The default is `one-time`.
     */
    @JvmName("fdpicylvkuvoeokd")
    public suspend fun spotInstanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spotInstanceType = mapped
    }

    /**
     * @param value The end date of the request, in UTC format (YYYY-MM-DDTHH:MM:SSZ). Supported only for persistent requests.
     */
    @JvmName("brsiyyakepgbvbnb")
    public suspend fun validUntil(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validUntil = mapped
    }

    internal fun build(): InstanceInstanceMarketOptionsSpotOptionsArgs =
        InstanceInstanceMarketOptionsSpotOptionsArgs(
            instanceInterruptionBehavior = instanceInterruptionBehavior,
            maxPrice = maxPrice,
            spotInstanceType = spotInstanceType,
            validUntil = validUntil,
        )
}
