@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.InstanceLaunchTemplateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property id ID of the launch template. Conflicts with `name`.
 * @property name Name of the launch template. Conflicts with `id`.
 * @property version Template version. Can be a specific version number, `$Latest` or `$Default`. The default value is `$Default`.
 */
public data class InstanceLaunchTemplateArgs(
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.InstanceLaunchTemplateArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.InstanceLaunchTemplateArgs =
        com.pulumi.aws.ec2.inputs.InstanceLaunchTemplateArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceLaunchTemplateArgs].
 */
@PulumiTagMarker
public class InstanceLaunchTemplateArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value ID of the launch template. Conflicts with `name`.
     */
    @JvmName("tjthbuodguqmgkxf")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Name of the launch template. Conflicts with `id`.
     */
    @JvmName("bhgdoonkvtwiwqkt")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Template version. Can be a specific version number, `$Latest` or `$Default`. The default value is `$Default`.
     */
    @JvmName("rhoytcfauonuqfnj")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value ID of the launch template. Conflicts with `name`.
     */
    @JvmName("ayilnavdmspwdidl")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Name of the launch template. Conflicts with `id`.
     */
    @JvmName("ndabyuhymetqfpxv")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Template version. Can be a specific version number, `$Latest` or `$Default`. The default value is `$Default`.
     */
    @JvmName("tllqneamgrckqeyc")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): InstanceLaunchTemplateArgs = InstanceLaunchTemplateArgs(
        id = id,
        name = name,
        version = version,
    )
}
