@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.InstancePrivateDnsNameOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enableResourceNameDnsARecord Indicates whether to respond to DNS queries for instance hostnames with DNS A records.
 * @property enableResourceNameDnsAaaaRecord Indicates whether to respond to DNS queries for instance hostnames with DNS AAAA records.
 * @property hostnameType Type of hostname for Amazon EC2 instances. For IPv4 only subnets, an instance DNS name must be based on the instance IPv4 address. For IPv6 native subnets, an instance DNS name must be based on the instance ID. For dual-stack subnets, you can specify whether DNS names use the instance IPv4 address or the instance ID. Valid values: `ip-name` and `resource-name`.
 */
public data class InstancePrivateDnsNameOptionsArgs(
    public val enableResourceNameDnsARecord: Output<Boolean>? = null,
    public val enableResourceNameDnsAaaaRecord: Output<Boolean>? = null,
    public val hostnameType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.InstancePrivateDnsNameOptionsArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.InstancePrivateDnsNameOptionsArgs =
        com.pulumi.aws.ec2.inputs.InstancePrivateDnsNameOptionsArgs.builder()
            .enableResourceNameDnsARecord(enableResourceNameDnsARecord?.applyValue({ args0 -> args0 }))
            .enableResourceNameDnsAaaaRecord(enableResourceNameDnsAaaaRecord?.applyValue({ args0 -> args0 }))
            .hostnameType(hostnameType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstancePrivateDnsNameOptionsArgs].
 */
@PulumiTagMarker
public class InstancePrivateDnsNameOptionsArgsBuilder internal constructor() {
    private var enableResourceNameDnsARecord: Output<Boolean>? = null

    private var enableResourceNameDnsAaaaRecord: Output<Boolean>? = null

    private var hostnameType: Output<String>? = null

    /**
     * @param value Indicates whether to respond to DNS queries for instance hostnames with DNS A records.
     */
    @JvmName("aadaylsmupljvshl")
    public suspend fun enableResourceNameDnsARecord(`value`: Output<Boolean>) {
        this.enableResourceNameDnsARecord = value
    }

    /**
     * @param value Indicates whether to respond to DNS queries for instance hostnames with DNS AAAA records.
     */
    @JvmName("ogyqqoednnoygyyc")
    public suspend fun enableResourceNameDnsAaaaRecord(`value`: Output<Boolean>) {
        this.enableResourceNameDnsAaaaRecord = value
    }

    /**
     * @param value Type of hostname for Amazon EC2 instances. For IPv4 only subnets, an instance DNS name must be based on the instance IPv4 address. For IPv6 native subnets, an instance DNS name must be based on the instance ID. For dual-stack subnets, you can specify whether DNS names use the instance IPv4 address or the instance ID. Valid values: `ip-name` and `resource-name`.
     */
    @JvmName("jqvnwxhugplsbaio")
    public suspend fun hostnameType(`value`: Output<String>) {
        this.hostnameType = value
    }

    /**
     * @param value Indicates whether to respond to DNS queries for instance hostnames with DNS A records.
     */
    @JvmName("ybfvudagmohsxmlh")
    public suspend fun enableResourceNameDnsARecord(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableResourceNameDnsARecord = mapped
    }

    /**
     * @param value Indicates whether to respond to DNS queries for instance hostnames with DNS AAAA records.
     */
    @JvmName("lqtwhfugnjovjfha")
    public suspend fun enableResourceNameDnsAaaaRecord(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableResourceNameDnsAaaaRecord = mapped
    }

    /**
     * @param value Type of hostname for Amazon EC2 instances. For IPv4 only subnets, an instance DNS name must be based on the instance IPv4 address. For IPv6 native subnets, an instance DNS name must be based on the instance ID. For dual-stack subnets, you can specify whether DNS names use the instance IPv4 address or the instance ID. Valid values: `ip-name` and `resource-name`.
     */
    @JvmName("nxnevoihqqottgni")
    public suspend fun hostnameType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostnameType = mapped
    }

    internal fun build(): InstancePrivateDnsNameOptionsArgs = InstancePrivateDnsNameOptionsArgs(
        enableResourceNameDnsARecord = enableResourceNameDnsARecord,
        enableResourceNameDnsAaaaRecord = enableResourceNameDnsAaaaRecord,
        hostnameType = hostnameType,
    )
}
