@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.InstanceRootBlockDeviceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property deleteOnTermination Whether the volume should be destroyed on instance termination. Defaults to `true`.
 * @property deviceName Device name, e.g., `/dev/sdh` or `xvdh`.
 * @property encrypted Whether to enable volume encryption. Defaults to `false`. Must be configured to perform drift detection.
 * @property iops Amount of provisioned [IOPS](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-io-characteristics.html). Only valid for volume_type of `io1`, `io2` or `gp3`.
 * @property kmsKeyId Amazon Resource Name (ARN) of the KMS Key to use when encrypting the volume. Must be configured to perform drift detection.
 * @property tags Map of tags to assign to the device.
 * @property tagsAll Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
 * @property throughput Throughput to provision for a volume in mebibytes per second (MiB/s). This is only valid for `volume_type` of `gp3`.
 * @property volumeId ID of the volume. For example, the ID can be accessed like this, `aws_instance.web.root_block_device.0.volume_id`.
 * @property volumeSize Size of the volume in gibibytes (GiB).
 * @property volumeType Type of volume. Valid values include `standard`, `gp2`, `gp3`, `io1`, `io2`, `sc1`, or `st1`. Defaults to the volume type that the AMI uses.
 * Modifying the `encrypted` or `kms_key_id` settings of the `root_block_device` requires resource replacement.
 */
public data class InstanceRootBlockDeviceArgs(
    public val deleteOnTermination: Output<Boolean>? = null,
    public val deviceName: Output<String>? = null,
    public val encrypted: Output<Boolean>? = null,
    public val iops: Output<Int>? = null,
    public val kmsKeyId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val tagsAll: Output<Map<String, String>>? = null,
    public val throughput: Output<Int>? = null,
    public val volumeId: Output<String>? = null,
    public val volumeSize: Output<Int>? = null,
    public val volumeType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.InstanceRootBlockDeviceArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.InstanceRootBlockDeviceArgs =
        com.pulumi.aws.ec2.inputs.InstanceRootBlockDeviceArgs.builder()
            .deleteOnTermination(deleteOnTermination?.applyValue({ args0 -> args0 }))
            .deviceName(deviceName?.applyValue({ args0 -> args0 }))
            .encrypted(encrypted?.applyValue({ args0 -> args0 }))
            .iops(iops?.applyValue({ args0 -> args0 }))
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .tagsAll(tagsAll?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .throughput(throughput?.applyValue({ args0 -> args0 }))
            .volumeId(volumeId?.applyValue({ args0 -> args0 }))
            .volumeSize(volumeSize?.applyValue({ args0 -> args0 }))
            .volumeType(volumeType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceRootBlockDeviceArgs].
 */
@PulumiTagMarker
public class InstanceRootBlockDeviceArgsBuilder internal constructor() {
    private var deleteOnTermination: Output<Boolean>? = null

    private var deviceName: Output<String>? = null

    private var encrypted: Output<Boolean>? = null

    private var iops: Output<Int>? = null

    private var kmsKeyId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var tagsAll: Output<Map<String, String>>? = null

    private var throughput: Output<Int>? = null

    private var volumeId: Output<String>? = null

    private var volumeSize: Output<Int>? = null

    private var volumeType: Output<String>? = null

    /**
     * @param value Whether the volume should be destroyed on instance termination. Defaults to `true`.
     */
    @JvmName("wqnwfdxqcbaccbhj")
    public suspend fun deleteOnTermination(`value`: Output<Boolean>) {
        this.deleteOnTermination = value
    }

    /**
     * @param value Device name, e.g., `/dev/sdh` or `xvdh`.
     */
    @JvmName("urirclteqdqpmosx")
    public suspend fun deviceName(`value`: Output<String>) {
        this.deviceName = value
    }

    /**
     * @param value Whether to enable volume encryption. Defaults to `false`. Must be configured to perform drift detection.
     */
    @JvmName("ycbyloxygbqfawej")
    public suspend fun encrypted(`value`: Output<Boolean>) {
        this.encrypted = value
    }

    /**
     * @param value Amount of provisioned [IOPS](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-io-characteristics.html). Only valid for volume_type of `io1`, `io2` or `gp3`.
     */
    @JvmName("vvtldfwhedboskwy")
    public suspend fun iops(`value`: Output<Int>) {
        this.iops = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of the KMS Key to use when encrypting the volume. Must be configured to perform drift detection.
     */
    @JvmName("gqqsfshqjvvtasfc")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value Map of tags to assign to the device.
     */
    @JvmName("rnscvxennoajipsa")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @JvmName("gstpbhhrwmislyka")
    public suspend fun tagsAll(`value`: Output<Map<String, String>>) {
        this.tagsAll = value
    }

    /**
     * @param value Throughput to provision for a volume in mebibytes per second (MiB/s). This is only valid for `volume_type` of `gp3`.
     */
    @JvmName("dxevkolcbjrechiq")
    public suspend fun throughput(`value`: Output<Int>) {
        this.throughput = value
    }

    /**
     * @param value ID of the volume. For example, the ID can be accessed like this, `aws_instance.web.root_block_device.0.volume_id`.
     */
    @JvmName("jugafeybotjqxtfy")
    public suspend fun volumeId(`value`: Output<String>) {
        this.volumeId = value
    }

    /**
     * @param value Size of the volume in gibibytes (GiB).
     */
    @JvmName("iqbnahadxisiajbt")
    public suspend fun volumeSize(`value`: Output<Int>) {
        this.volumeSize = value
    }

    /**
     * @param value Type of volume. Valid values include `standard`, `gp2`, `gp3`, `io1`, `io2`, `sc1`, or `st1`. Defaults to the volume type that the AMI uses.
     * Modifying the `encrypted` or `kms_key_id` settings of the `root_block_device` requires resource replacement.
     */
    @JvmName("dmawdgagotjqokil")
    public suspend fun volumeType(`value`: Output<String>) {
        this.volumeType = value
    }

    /**
     * @param value Whether the volume should be destroyed on instance termination. Defaults to `true`.
     */
    @JvmName("ndkatnmcjymwvqoj")
    public suspend fun deleteOnTermination(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteOnTermination = mapped
    }

    /**
     * @param value Device name, e.g., `/dev/sdh` or `xvdh`.
     */
    @JvmName("ampfldiyllbgdxnv")
    public suspend fun deviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceName = mapped
    }

    /**
     * @param value Whether to enable volume encryption. Defaults to `false`. Must be configured to perform drift detection.
     */
    @JvmName("qyuqkdovevnglbhr")
    public suspend fun encrypted(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encrypted = mapped
    }

    /**
     * @param value Amount of provisioned [IOPS](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-io-characteristics.html). Only valid for volume_type of `io1`, `io2` or `gp3`.
     */
    @JvmName("lianlinvakdqfgcm")
    public suspend fun iops(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iops = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of the KMS Key to use when encrypting the volume. Must be configured to perform drift detection.
     */
    @JvmName("ajkdwtclttxwebmh")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value Map of tags to assign to the device.
     */
    @JvmName("kbikcxcfclfelhlw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the device.
     */
    @JvmName("klabkldpriylwdgt")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @JvmName("rbotnagyuobtitbg")
    public suspend fun tagsAll(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tagsAll = mapped
    }

    /**
     * @param values Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @JvmName("lccvjtiwckjmbmva")
    public fun tagsAll(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tagsAll = mapped
    }

    /**
     * @param value Throughput to provision for a volume in mebibytes per second (MiB/s). This is only valid for `volume_type` of `gp3`.
     */
    @JvmName("grwahsyljctibjqv")
    public suspend fun throughput(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.throughput = mapped
    }

    /**
     * @param value ID of the volume. For example, the ID can be accessed like this, `aws_instance.web.root_block_device.0.volume_id`.
     */
    @JvmName("ooanlhvlkmdjhqxf")
    public suspend fun volumeId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeId = mapped
    }

    /**
     * @param value Size of the volume in gibibytes (GiB).
     */
    @JvmName("dvywjpxnmvxjbevk")
    public suspend fun volumeSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeSize = mapped
    }

    /**
     * @param value Type of volume. Valid values include `standard`, `gp2`, `gp3`, `io1`, `io2`, `sc1`, or `st1`. Defaults to the volume type that the AMI uses.
     * Modifying the `encrypted` or `kms_key_id` settings of the `root_block_device` requires resource replacement.
     */
    @JvmName("tfufcghxgkekkymf")
    public suspend fun volumeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeType = mapped
    }

    internal fun build(): InstanceRootBlockDeviceArgs = InstanceRootBlockDeviceArgs(
        deleteOnTermination = deleteOnTermination,
        deviceName = deviceName,
        encrypted = encrypted,
        iops = iops,
        kmsKeyId = kmsKeyId,
        tags = tags,
        tagsAll = tagsAll,
        throughput = throughput,
        volumeId = volumeId,
        volumeSize = volumeSize,
        volumeType = volumeType,
    )
}
