@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.LaunchConfigurationEbsBlockDeviceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property deleteOnTermination
 * @property deviceName
 * @property encrypted
 * @property iops
 * @property noDevice
 * @property snapshotId
 * @property throughput
 * @property volumeSize
 * @property volumeType
 */
public data class LaunchConfigurationEbsBlockDeviceArgs(
    public val deleteOnTermination: Output<Boolean>? = null,
    public val deviceName: Output<String>,
    public val encrypted: Output<Boolean>? = null,
    public val iops: Output<Int>? = null,
    public val noDevice: Output<Boolean>? = null,
    public val snapshotId: Output<String>? = null,
    public val throughput: Output<Int>? = null,
    public val volumeSize: Output<Int>? = null,
    public val volumeType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.LaunchConfigurationEbsBlockDeviceArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.LaunchConfigurationEbsBlockDeviceArgs =
        com.pulumi.aws.ec2.inputs.LaunchConfigurationEbsBlockDeviceArgs.builder()
            .deleteOnTermination(deleteOnTermination?.applyValue({ args0 -> args0 }))
            .deviceName(deviceName.applyValue({ args0 -> args0 }))
            .encrypted(encrypted?.applyValue({ args0 -> args0 }))
            .iops(iops?.applyValue({ args0 -> args0 }))
            .noDevice(noDevice?.applyValue({ args0 -> args0 }))
            .snapshotId(snapshotId?.applyValue({ args0 -> args0 }))
            .throughput(throughput?.applyValue({ args0 -> args0 }))
            .volumeSize(volumeSize?.applyValue({ args0 -> args0 }))
            .volumeType(volumeType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LaunchConfigurationEbsBlockDeviceArgs].
 */
@PulumiTagMarker
public class LaunchConfigurationEbsBlockDeviceArgsBuilder internal constructor() {
    private var deleteOnTermination: Output<Boolean>? = null

    private var deviceName: Output<String>? = null

    private var encrypted: Output<Boolean>? = null

    private var iops: Output<Int>? = null

    private var noDevice: Output<Boolean>? = null

    private var snapshotId: Output<String>? = null

    private var throughput: Output<Int>? = null

    private var volumeSize: Output<Int>? = null

    private var volumeType: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("veeyxkfuictxohbk")
    public suspend fun deleteOnTermination(`value`: Output<Boolean>) {
        this.deleteOnTermination = value
    }

    /**
     * @param value
     */
    @JvmName("jlgerlrhvvfelret")
    public suspend fun deviceName(`value`: Output<String>) {
        this.deviceName = value
    }

    /**
     * @param value
     */
    @JvmName("kvykhctjykvehdqp")
    public suspend fun encrypted(`value`: Output<Boolean>) {
        this.encrypted = value
    }

    /**
     * @param value
     */
    @JvmName("hcftfegiaqqlwjui")
    public suspend fun iops(`value`: Output<Int>) {
        this.iops = value
    }

    /**
     * @param value
     */
    @JvmName("pjkmdggoemfspsij")
    public suspend fun noDevice(`value`: Output<Boolean>) {
        this.noDevice = value
    }

    /**
     * @param value
     */
    @JvmName("tijllpbcvowdaijk")
    public suspend fun snapshotId(`value`: Output<String>) {
        this.snapshotId = value
    }

    /**
     * @param value
     */
    @JvmName("ctrahddboxuxfxsm")
    public suspend fun throughput(`value`: Output<Int>) {
        this.throughput = value
    }

    /**
     * @param value
     */
    @JvmName("emachjgdoiybiuqe")
    public suspend fun volumeSize(`value`: Output<Int>) {
        this.volumeSize = value
    }

    /**
     * @param value
     */
    @JvmName("jkvruqolcsiasbgh")
    public suspend fun volumeType(`value`: Output<String>) {
        this.volumeType = value
    }

    /**
     * @param value
     */
    @JvmName("fmmctwrltcxamjob")
    public suspend fun deleteOnTermination(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteOnTermination = mapped
    }

    /**
     * @param value
     */
    @JvmName("ptdhqojoqvstbtso")
    public suspend fun deviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deviceName = mapped
    }

    /**
     * @param value
     */
    @JvmName("aarlvdyuphdcdxyy")
    public suspend fun encrypted(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encrypted = mapped
    }

    /**
     * @param value
     */
    @JvmName("vvyvxtjlxalbsoff")
    public suspend fun iops(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iops = mapped
    }

    /**
     * @param value
     */
    @JvmName("njbnbaabvswygjwf")
    public suspend fun noDevice(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.noDevice = mapped
    }

    /**
     * @param value
     */
    @JvmName("knbfasurteebpixb")
    public suspend fun snapshotId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotId = mapped
    }

    /**
     * @param value
     */
    @JvmName("yetxsclsqhtamify")
    public suspend fun throughput(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.throughput = mapped
    }

    /**
     * @param value
     */
    @JvmName("kpploexujsisypvp")
    public suspend fun volumeSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeSize = mapped
    }

    /**
     * @param value
     */
    @JvmName("jlneshdxmglpcugp")
    public suspend fun volumeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeType = mapped
    }

    internal fun build(): LaunchConfigurationEbsBlockDeviceArgs =
        LaunchConfigurationEbsBlockDeviceArgs(
            deleteOnTermination = deleteOnTermination,
            deviceName = deviceName ?: throw PulumiNullFieldException("deviceName"),
            encrypted = encrypted,
            iops = iops,
            noDevice = noDevice,
            snapshotId = snapshotId,
            throughput = throughput,
            volumeSize = volumeSize,
            volumeType = volumeType,
        )
}
