@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.LaunchConfigurationEphemeralBlockDeviceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property deviceName
 * @property noDevice
 * @property virtualName
 */
public data class LaunchConfigurationEphemeralBlockDeviceArgs(
    public val deviceName: Output<String>,
    public val noDevice: Output<Boolean>? = null,
    public val virtualName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.LaunchConfigurationEphemeralBlockDeviceArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.LaunchConfigurationEphemeralBlockDeviceArgs =
        com.pulumi.aws.ec2.inputs.LaunchConfigurationEphemeralBlockDeviceArgs.builder()
            .deviceName(deviceName.applyValue({ args0 -> args0 }))
            .noDevice(noDevice?.applyValue({ args0 -> args0 }))
            .virtualName(virtualName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LaunchConfigurationEphemeralBlockDeviceArgs].
 */
@PulumiTagMarker
public class LaunchConfigurationEphemeralBlockDeviceArgsBuilder internal constructor() {
    private var deviceName: Output<String>? = null

    private var noDevice: Output<Boolean>? = null

    private var virtualName: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("prepwufmoxmjocog")
    public suspend fun deviceName(`value`: Output<String>) {
        this.deviceName = value
    }

    /**
     * @param value
     */
    @JvmName("ksfbqwcvkeuwlwjf")
    public suspend fun noDevice(`value`: Output<Boolean>) {
        this.noDevice = value
    }

    /**
     * @param value
     */
    @JvmName("jhsgbgrhiuxwjbpq")
    public suspend fun virtualName(`value`: Output<String>) {
        this.virtualName = value
    }

    /**
     * @param value
     */
    @JvmName("eopklhinttsorkca")
    public suspend fun deviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deviceName = mapped
    }

    /**
     * @param value
     */
    @JvmName("ktkrvpbagexxoiga")
    public suspend fun noDevice(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.noDevice = mapped
    }

    /**
     * @param value
     */
    @JvmName("yeojhsnihpmrerhp")
    public suspend fun virtualName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualName = mapped
    }

    internal fun build(): LaunchConfigurationEphemeralBlockDeviceArgs =
        LaunchConfigurationEphemeralBlockDeviceArgs(
            deviceName = deviceName ?: throw PulumiNullFieldException("deviceName"),
            noDevice = noDevice,
            virtualName = virtualName,
        )
}
