@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.LaunchConfigurationMetadataOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property httpEndpoint The state of the metadata service: `enabled`, `disabled`.
 * @property httpPutResponseHopLimit The desired HTTP PUT response hop limit for instance metadata requests.
 * @property httpTokens If session tokens are required: `optional`, `required`.
 */
public data class LaunchConfigurationMetadataOptionsArgs(
    public val httpEndpoint: Output<String>? = null,
    public val httpPutResponseHopLimit: Output<Int>? = null,
    public val httpTokens: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.LaunchConfigurationMetadataOptionsArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.LaunchConfigurationMetadataOptionsArgs =
        com.pulumi.aws.ec2.inputs.LaunchConfigurationMetadataOptionsArgs.builder()
            .httpEndpoint(httpEndpoint?.applyValue({ args0 -> args0 }))
            .httpPutResponseHopLimit(httpPutResponseHopLimit?.applyValue({ args0 -> args0 }))
            .httpTokens(httpTokens?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LaunchConfigurationMetadataOptionsArgs].
 */
@PulumiTagMarker
public class LaunchConfigurationMetadataOptionsArgsBuilder internal constructor() {
    private var httpEndpoint: Output<String>? = null

    private var httpPutResponseHopLimit: Output<Int>? = null

    private var httpTokens: Output<String>? = null

    /**
     * @param value The state of the metadata service: `enabled`, `disabled`.
     */
    @JvmName("xemajwjgreuqfxkk")
    public suspend fun httpEndpoint(`value`: Output<String>) {
        this.httpEndpoint = value
    }

    /**
     * @param value The desired HTTP PUT response hop limit for instance metadata requests.
     */
    @JvmName("aklmkdopxwqkgsac")
    public suspend fun httpPutResponseHopLimit(`value`: Output<Int>) {
        this.httpPutResponseHopLimit = value
    }

    /**
     * @param value If session tokens are required: `optional`, `required`.
     */
    @JvmName("mqgxdswgpdcbafpi")
    public suspend fun httpTokens(`value`: Output<String>) {
        this.httpTokens = value
    }

    /**
     * @param value The state of the metadata service: `enabled`, `disabled`.
     */
    @JvmName("ejtuigdmtiunrmny")
    public suspend fun httpEndpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpEndpoint = mapped
    }

    /**
     * @param value The desired HTTP PUT response hop limit for instance metadata requests.
     */
    @JvmName("gykeoxdgyilostmt")
    public suspend fun httpPutResponseHopLimit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpPutResponseHopLimit = mapped
    }

    /**
     * @param value If session tokens are required: `optional`, `required`.
     */
    @JvmName("cojrnmjlgyjqqlkm")
    public suspend fun httpTokens(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpTokens = mapped
    }

    internal fun build(): LaunchConfigurationMetadataOptionsArgs =
        LaunchConfigurationMetadataOptionsArgs(
            httpEndpoint = httpEndpoint,
            httpPutResponseHopLimit = httpPutResponseHopLimit,
            httpTokens = httpTokens,
        )
}
