@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.LaunchTemplateBlockDeviceMappingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property deviceName The name of the device to mount.
 * @property ebs Configure EBS volume properties.
 * @property noDevice Suppresses the specified device included in the AMI's block device mapping.
 * @property virtualName The [Instance Store Device
 * Name](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#InstanceStoreDeviceNames)
 * (e.g., `"ephemeral0"`).
 */
public data class LaunchTemplateBlockDeviceMappingArgs(
    public val deviceName: Output<String>? = null,
    public val ebs: Output<LaunchTemplateBlockDeviceMappingEbsArgs>? = null,
    public val noDevice: Output<String>? = null,
    public val virtualName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.LaunchTemplateBlockDeviceMappingArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.LaunchTemplateBlockDeviceMappingArgs =
        com.pulumi.aws.ec2.inputs.LaunchTemplateBlockDeviceMappingArgs.builder()
            .deviceName(deviceName?.applyValue({ args0 -> args0 }))
            .ebs(ebs?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .noDevice(noDevice?.applyValue({ args0 -> args0 }))
            .virtualName(virtualName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LaunchTemplateBlockDeviceMappingArgs].
 */
@PulumiTagMarker
public class LaunchTemplateBlockDeviceMappingArgsBuilder internal constructor() {
    private var deviceName: Output<String>? = null

    private var ebs: Output<LaunchTemplateBlockDeviceMappingEbsArgs>? = null

    private var noDevice: Output<String>? = null

    private var virtualName: Output<String>? = null

    /**
     * @param value The name of the device to mount.
     */
    @JvmName("slksqbfnhmmujogb")
    public suspend fun deviceName(`value`: Output<String>) {
        this.deviceName = value
    }

    /**
     * @param value Configure EBS volume properties.
     */
    @JvmName("kcnwjeanekdgibhk")
    public suspend fun ebs(`value`: Output<LaunchTemplateBlockDeviceMappingEbsArgs>) {
        this.ebs = value
    }

    /**
     * @param value Suppresses the specified device included in the AMI's block device mapping.
     */
    @JvmName("khboaiflmdphjrkm")
    public suspend fun noDevice(`value`: Output<String>) {
        this.noDevice = value
    }

    /**
     * @param value The [Instance Store Device
   * Name](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#InstanceStoreDeviceNames)
     * (e.g., `"ephemeral0"`).
     */
    @JvmName("qgegpgcleowoaefe")
    public suspend fun virtualName(`value`: Output<String>) {
        this.virtualName = value
    }

    /**
     * @param value The name of the device to mount.
     */
    @JvmName("rdurqaedkgmmxqsw")
    public suspend fun deviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceName = mapped
    }

    /**
     * @param value Configure EBS volume properties.
     */
    @JvmName("rsqrdrpypdypjdai")
    public suspend fun ebs(`value`: LaunchTemplateBlockDeviceMappingEbsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ebs = mapped
    }

    /**
     * @param argument Configure EBS volume properties.
     */
    @JvmName("qinxkcgqsonckhar")
    public suspend fun ebs(argument: suspend LaunchTemplateBlockDeviceMappingEbsArgsBuilder.() -> Unit) {
        val toBeMapped = LaunchTemplateBlockDeviceMappingEbsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.ebs = mapped
    }

    /**
     * @param value Suppresses the specified device included in the AMI's block device mapping.
     */
    @JvmName("nondvgcdxplovqlm")
    public suspend fun noDevice(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.noDevice = mapped
    }

    /**
     * @param value The [Instance Store Device
   * Name](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#InstanceStoreDeviceNames)
     * (e.g., `"ephemeral0"`).
     */
    @JvmName("bmjhkclgxjxjycbj")
    public suspend fun virtualName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualName = mapped
    }

    internal fun build(): LaunchTemplateBlockDeviceMappingArgs = LaunchTemplateBlockDeviceMappingArgs(
        deviceName = deviceName,
        ebs = ebs,
        noDevice = noDevice,
        virtualName = virtualName,
    )
}
