@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.LaunchTemplateBlockDeviceMappingEbsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property deleteOnTermination Whether the volume should be destroyed on instance termination.
 * See [Preserving Amazon EBS Volumes on Instance Termination](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/preserving-volumes-on-termination.html) for more information.
 * @property encrypted Enables [EBS encryption](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html) on the volume.
 * Cannot be used with `snapshot_id`.
 * @property iops The amount of provisioned [IOPS](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-io-characteristics.html).
 * This must be set with a `volume_type` of `"io1/io2/gp3"`.
 * @property kmsKeyId The ARN of the AWS Key Management Service (AWS KMS) customer master key (CMK) to use when creating the encrypted volume.
 * `encrypted` must be set to `true` when this is set.
 * @property snapshotId The Snapshot ID to mount.
 * @property throughput The throughput to provision for a `gp3` volume in MiB/s (specified as an integer, e.g., 500), with a maximum of 1,000 MiB/s.
 * @property volumeSize The size of the volume in gigabytes.
 * @property volumeType The volume type.
 * Can be one of `standard`, `gp2`, `gp3`, `io1`, `io2`, `sc1` or `st1`.
 */
public data class LaunchTemplateBlockDeviceMappingEbsArgs(
    public val deleteOnTermination: Output<String>? = null,
    public val encrypted: Output<String>? = null,
    public val iops: Output<Int>? = null,
    public val kmsKeyId: Output<String>? = null,
    public val snapshotId: Output<String>? = null,
    public val throughput: Output<Int>? = null,
    public val volumeSize: Output<Int>? = null,
    public val volumeType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.LaunchTemplateBlockDeviceMappingEbsArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.LaunchTemplateBlockDeviceMappingEbsArgs =
        com.pulumi.aws.ec2.inputs.LaunchTemplateBlockDeviceMappingEbsArgs.builder()
            .deleteOnTermination(deleteOnTermination?.applyValue({ args0 -> args0 }))
            .encrypted(encrypted?.applyValue({ args0 -> args0 }))
            .iops(iops?.applyValue({ args0 -> args0 }))
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .snapshotId(snapshotId?.applyValue({ args0 -> args0 }))
            .throughput(throughput?.applyValue({ args0 -> args0 }))
            .volumeSize(volumeSize?.applyValue({ args0 -> args0 }))
            .volumeType(volumeType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LaunchTemplateBlockDeviceMappingEbsArgs].
 */
@PulumiTagMarker
public class LaunchTemplateBlockDeviceMappingEbsArgsBuilder internal constructor() {
    private var deleteOnTermination: Output<String>? = null

    private var encrypted: Output<String>? = null

    private var iops: Output<Int>? = null

    private var kmsKeyId: Output<String>? = null

    private var snapshotId: Output<String>? = null

    private var throughput: Output<Int>? = null

    private var volumeSize: Output<Int>? = null

    private var volumeType: Output<String>? = null

    /**
     * @param value Whether the volume should be destroyed on instance termination.
     * See [Preserving Amazon EBS Volumes on Instance Termination](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/preserving-volumes-on-termination.html) for more information.
     */
    @JvmName("ukgcikbipavotqki")
    public suspend fun deleteOnTermination(`value`: Output<String>) {
        this.deleteOnTermination = value
    }

    /**
     * @param value Enables [EBS encryption](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html) on the volume.
     * Cannot be used with `snapshot_id`.
     */
    @JvmName("mpvflultotsfhncv")
    public suspend fun encrypted(`value`: Output<String>) {
        this.encrypted = value
    }

    /**
     * @param value The amount of provisioned [IOPS](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-io-characteristics.html).
     * This must be set with a `volume_type` of `"io1/io2/gp3"`.
     */
    @JvmName("rcruqgghinhpuqdn")
    public suspend fun iops(`value`: Output<Int>) {
        this.iops = value
    }

    /**
     * @param value The ARN of the AWS Key Management Service (AWS KMS) customer master key (CMK) to use when creating the encrypted volume.
     * `encrypted` must be set to `true` when this is set.
     */
    @JvmName("bfjydtqqpjslgpsp")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value The Snapshot ID to mount.
     */
    @JvmName("btlqkwphnnhkcxcn")
    public suspend fun snapshotId(`value`: Output<String>) {
        this.snapshotId = value
    }

    /**
     * @param value The throughput to provision for a `gp3` volume in MiB/s (specified as an integer, e.g., 500), with a maximum of 1,000 MiB/s.
     */
    @JvmName("qsugtebjnmxkjrxy")
    public suspend fun throughput(`value`: Output<Int>) {
        this.throughput = value
    }

    /**
     * @param value The size of the volume in gigabytes.
     */
    @JvmName("qxyrrovlwmjlrriu")
    public suspend fun volumeSize(`value`: Output<Int>) {
        this.volumeSize = value
    }

    /**
     * @param value The volume type.
     * Can be one of `standard`, `gp2`, `gp3`, `io1`, `io2`, `sc1` or `st1`.
     */
    @JvmName("bmdyrnqieodvoehn")
    public suspend fun volumeType(`value`: Output<String>) {
        this.volumeType = value
    }

    /**
     * @param value Whether the volume should be destroyed on instance termination.
     * See [Preserving Amazon EBS Volumes on Instance Termination](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/preserving-volumes-on-termination.html) for more information.
     */
    @JvmName("ccdmsdqnxhduatov")
    public suspend fun deleteOnTermination(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteOnTermination = mapped
    }

    /**
     * @param value Enables [EBS encryption](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html) on the volume.
     * Cannot be used with `snapshot_id`.
     */
    @JvmName("briutjdceflwbrhl")
    public suspend fun encrypted(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encrypted = mapped
    }

    /**
     * @param value The amount of provisioned [IOPS](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-io-characteristics.html).
     * This must be set with a `volume_type` of `"io1/io2/gp3"`.
     */
    @JvmName("hktmlultaxljrnbu")
    public suspend fun iops(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iops = mapped
    }

    /**
     * @param value The ARN of the AWS Key Management Service (AWS KMS) customer master key (CMK) to use when creating the encrypted volume.
     * `encrypted` must be set to `true` when this is set.
     */
    @JvmName("iphreyiobsokdjld")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value The Snapshot ID to mount.
     */
    @JvmName("mhmlqlxmgkbwgkln")
    public suspend fun snapshotId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotId = mapped
    }

    /**
     * @param value The throughput to provision for a `gp3` volume in MiB/s (specified as an integer, e.g., 500), with a maximum of 1,000 MiB/s.
     */
    @JvmName("osgxiibsxxukscdp")
    public suspend fun throughput(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.throughput = mapped
    }

    /**
     * @param value The size of the volume in gigabytes.
     */
    @JvmName("bphdaanaxwlocxfo")
    public suspend fun volumeSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeSize = mapped
    }

    /**
     * @param value The volume type.
     * Can be one of `standard`, `gp2`, `gp3`, `io1`, `io2`, `sc1` or `st1`.
     */
    @JvmName("unbufmlcpcsrvckw")
    public suspend fun volumeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeType = mapped
    }

    internal fun build(): LaunchTemplateBlockDeviceMappingEbsArgs =
        LaunchTemplateBlockDeviceMappingEbsArgs(
            deleteOnTermination = deleteOnTermination,
            encrypted = encrypted,
            iops = iops,
            kmsKeyId = kmsKeyId,
            snapshotId = snapshotId,
            throughput = throughput,
            volumeSize = volumeSize,
            volumeType = volumeType,
        )
}
