@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.LaunchTemplateCapacityReservationSpecificationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property capacityReservationPreference Indicates the instance's Capacity Reservation preferences. Can be `open` or `none`. (Default `none`).
 * @property capacityReservationTarget Used to target a specific Capacity Reservation:
 */
public data class LaunchTemplateCapacityReservationSpecificationArgs(
    public val capacityReservationPreference: Output<String>? = null,
    public val capacityReservationTarget: Output<LaunchTemplateCapacityReservationSpecificationCapacityReservationTargetArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.LaunchTemplateCapacityReservationSpecificationArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.LaunchTemplateCapacityReservationSpecificationArgs =
        com.pulumi.aws.ec2.inputs.LaunchTemplateCapacityReservationSpecificationArgs.builder()
            .capacityReservationPreference(capacityReservationPreference?.applyValue({ args0 -> args0 }))
            .capacityReservationTarget(
                capacityReservationTarget?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [LaunchTemplateCapacityReservationSpecificationArgs].
 */
@PulumiTagMarker
public class LaunchTemplateCapacityReservationSpecificationArgsBuilder internal constructor() {
    private var capacityReservationPreference: Output<String>? = null

    private var capacityReservationTarget:
        Output<LaunchTemplateCapacityReservationSpecificationCapacityReservationTargetArgs>? = null

    /**
     * @param value Indicates the instance's Capacity Reservation preferences. Can be `open` or `none`. (Default `none`).
     */
    @JvmName("vrvqxybcmfliaswn")
    public suspend fun capacityReservationPreference(`value`: Output<String>) {
        this.capacityReservationPreference = value
    }

    /**
     * @param value Used to target a specific Capacity Reservation:
     */
    @JvmName("tqgkrqhwhikcroas")
    public suspend fun capacityReservationTarget(`value`: Output<LaunchTemplateCapacityReservationSpecificationCapacityReservationTargetArgs>) {
        this.capacityReservationTarget = value
    }

    /**
     * @param value Indicates the instance's Capacity Reservation preferences. Can be `open` or `none`. (Default `none`).
     */
    @JvmName("pnqstfrsktwvrvlf")
    public suspend fun capacityReservationPreference(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacityReservationPreference = mapped
    }

    /**
     * @param value Used to target a specific Capacity Reservation:
     */
    @JvmName("xafhnfmisevoyffu")
    public suspend fun capacityReservationTarget(`value`: LaunchTemplateCapacityReservationSpecificationCapacityReservationTargetArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacityReservationTarget = mapped
    }

    /**
     * @param argument Used to target a specific Capacity Reservation:
     */
    @JvmName("ybigyohnvltvbuxk")
    public suspend fun capacityReservationTarget(argument: suspend LaunchTemplateCapacityReservationSpecificationCapacityReservationTargetArgsBuilder.() -> Unit) {
        val toBeMapped =
            LaunchTemplateCapacityReservationSpecificationCapacityReservationTargetArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.capacityReservationTarget = mapped
    }

    internal fun build(): LaunchTemplateCapacityReservationSpecificationArgs =
        LaunchTemplateCapacityReservationSpecificationArgs(
            capacityReservationPreference = capacityReservationPreference,
            capacityReservationTarget = capacityReservationTarget,
        )
}
