@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.LaunchTemplateCapacityReservationSpecificationCapacityReservationTargetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property capacityReservationId The ID of the Capacity Reservation in which to run the instance.
 * @property capacityReservationResourceGroupArn The ARN of the Capacity Reservation resource group in which to run the instance.
 */
public data class LaunchTemplateCapacityReservationSpecificationCapacityReservationTargetArgs(
    public val capacityReservationId: Output<String>? = null,
    public val capacityReservationResourceGroupArn: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.ec2.inputs.LaunchTemplateCapacityReservationSpecificationCapacityReservationTargetArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.LaunchTemplateCapacityReservationSpecificationCapacityReservationTargetArgs =
        com.pulumi.aws.ec2.inputs.LaunchTemplateCapacityReservationSpecificationCapacityReservationTargetArgs.builder()
            .capacityReservationId(capacityReservationId?.applyValue({ args0 -> args0 }))
            .capacityReservationResourceGroupArn(
                capacityReservationResourceGroupArn?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [LaunchTemplateCapacityReservationSpecificationCapacityReservationTargetArgs].
 */
@PulumiTagMarker
public class LaunchTemplateCapacityReservationSpecificationCapacityReservationTargetArgsBuilder
internal constructor() {
    private var capacityReservationId: Output<String>? = null

    private var capacityReservationResourceGroupArn: Output<String>? = null

    /**
     * @param value The ID of the Capacity Reservation in which to run the instance.
     */
    @JvmName("fphxsvtufcbkadrc")
    public suspend fun capacityReservationId(`value`: Output<String>) {
        this.capacityReservationId = value
    }

    /**
     * @param value The ARN of the Capacity Reservation resource group in which to run the instance.
     */
    @JvmName("wrcgbmwvqxljctjw")
    public suspend fun capacityReservationResourceGroupArn(`value`: Output<String>) {
        this.capacityReservationResourceGroupArn = value
    }

    /**
     * @param value The ID of the Capacity Reservation in which to run the instance.
     */
    @JvmName("sgqpdnojqkrbvuop")
    public suspend fun capacityReservationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacityReservationId = mapped
    }

    /**
     * @param value The ARN of the Capacity Reservation resource group in which to run the instance.
     */
    @JvmName("wdivjtcdcynimerd")
    public suspend fun capacityReservationResourceGroupArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacityReservationResourceGroupArn = mapped
    }

    internal fun build(): LaunchTemplateCapacityReservationSpecificationCapacityReservationTargetArgs = LaunchTemplateCapacityReservationSpecificationCapacityReservationTargetArgs(
        capacityReservationId = capacityReservationId,
        capacityReservationResourceGroupArn = capacityReservationResourceGroupArn,
    )
}
