@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.LaunchTemplateCpuOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property amdSevSnp Indicates whether to enable the instance for AMD SEV-SNP. AMD SEV-SNP is supported with M6a, R6a, and C6a instance types only. Valid values are `enabled` and `disabled`.
 * @property coreCount The number of CPU cores for the instance.
 * @property threadsPerCore The number of threads per CPU core.
 * To disable Intel Hyper-Threading Technology for the instance, specify a value of 1.
 * Otherwise, specify the default value of 2.
 * Both number of CPU cores and threads per core must be specified. Valid number of CPU cores and threads per core for the instance type can be found in the [CPU Options Documentation](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html?shortFooter=true#cpu-options-supported-instances-values)
 */
public data class LaunchTemplateCpuOptionsArgs(
    public val amdSevSnp: Output<String>? = null,
    public val coreCount: Output<Int>? = null,
    public val threadsPerCore: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.LaunchTemplateCpuOptionsArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.LaunchTemplateCpuOptionsArgs =
        com.pulumi.aws.ec2.inputs.LaunchTemplateCpuOptionsArgs.builder()
            .amdSevSnp(amdSevSnp?.applyValue({ args0 -> args0 }))
            .coreCount(coreCount?.applyValue({ args0 -> args0 }))
            .threadsPerCore(threadsPerCore?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LaunchTemplateCpuOptionsArgs].
 */
@PulumiTagMarker
public class LaunchTemplateCpuOptionsArgsBuilder internal constructor() {
    private var amdSevSnp: Output<String>? = null

    private var coreCount: Output<Int>? = null

    private var threadsPerCore: Output<Int>? = null

    /**
     * @param value Indicates whether to enable the instance for AMD SEV-SNP. AMD SEV-SNP is supported with M6a, R6a, and C6a instance types only. Valid values are `enabled` and `disabled`.
     */
    @JvmName("ewamokwgnmgxearg")
    public suspend fun amdSevSnp(`value`: Output<String>) {
        this.amdSevSnp = value
    }

    /**
     * @param value The number of CPU cores for the instance.
     */
    @JvmName("sprmruyuessbwrhs")
    public suspend fun coreCount(`value`: Output<Int>) {
        this.coreCount = value
    }

    /**
     * @param value The number of threads per CPU core.
     * To disable Intel Hyper-Threading Technology for the instance, specify a value of 1.
     * Otherwise, specify the default value of 2.
     * Both number of CPU cores and threads per core must be specified. Valid number of CPU cores and threads per core for the instance type can be found in the [CPU Options Documentation](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html?shortFooter=true#cpu-options-supported-instances-values)
     */
    @JvmName("ifevwfobomedrmel")
    public suspend fun threadsPerCore(`value`: Output<Int>) {
        this.threadsPerCore = value
    }

    /**
     * @param value Indicates whether to enable the instance for AMD SEV-SNP. AMD SEV-SNP is supported with M6a, R6a, and C6a instance types only. Valid values are `enabled` and `disabled`.
     */
    @JvmName("jgpragtkugssflou")
    public suspend fun amdSevSnp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.amdSevSnp = mapped
    }

    /**
     * @param value The number of CPU cores for the instance.
     */
    @JvmName("drndcgugglynbrwq")
    public suspend fun coreCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.coreCount = mapped
    }

    /**
     * @param value The number of threads per CPU core.
     * To disable Intel Hyper-Threading Technology for the instance, specify a value of 1.
     * Otherwise, specify the default value of 2.
     * Both number of CPU cores and threads per core must be specified. Valid number of CPU cores and threads per core for the instance type can be found in the [CPU Options Documentation](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html?shortFooter=true#cpu-options-supported-instances-values)
     */
    @JvmName("keyguophbmkuebgm")
    public suspend fun threadsPerCore(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.threadsPerCore = mapped
    }

    internal fun build(): LaunchTemplateCpuOptionsArgs = LaunchTemplateCpuOptionsArgs(
        amdSevSnp = amdSevSnp,
        coreCount = coreCount,
        threadsPerCore = threadsPerCore,
    )
}
