@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.LaunchTemplateEnclaveOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enabled If set to `true`, Nitro Enclaves will be enabled on the instance.
 * For more information, see the documentation on [Nitro Enclaves](https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave.html).
 */
public data class LaunchTemplateEnclaveOptionsArgs(
    public val enabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.LaunchTemplateEnclaveOptionsArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.LaunchTemplateEnclaveOptionsArgs =
        com.pulumi.aws.ec2.inputs.LaunchTemplateEnclaveOptionsArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LaunchTemplateEnclaveOptionsArgs].
 */
@PulumiTagMarker
public class LaunchTemplateEnclaveOptionsArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    /**
     * @param value If set to `true`, Nitro Enclaves will be enabled on the instance.
     * For more information, see the documentation on [Nitro Enclaves](https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave.html).
     */
    @JvmName("vofsdmdpqnmrlcmw")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value If set to `true`, Nitro Enclaves will be enabled on the instance.
     * For more information, see the documentation on [Nitro Enclaves](https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave.html).
     */
    @JvmName("mahljuojsfojuhyj")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    internal fun build(): LaunchTemplateEnclaveOptionsArgs = LaunchTemplateEnclaveOptionsArgs(
        enabled = enabled,
    )
}
