@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.LaunchTemplateHibernationOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property configured If set to `true`, the launched EC2 instance will hibernation enabled.
 */
public data class LaunchTemplateHibernationOptionsArgs(
    public val configured: Output<Boolean>,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.LaunchTemplateHibernationOptionsArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.LaunchTemplateHibernationOptionsArgs =
        com.pulumi.aws.ec2.inputs.LaunchTemplateHibernationOptionsArgs.builder()
            .configured(configured.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LaunchTemplateHibernationOptionsArgs].
 */
@PulumiTagMarker
public class LaunchTemplateHibernationOptionsArgsBuilder internal constructor() {
    private var configured: Output<Boolean>? = null

    /**
     * @param value If set to `true`, the launched EC2 instance will hibernation enabled.
     */
    @JvmName("eurdytsyriswmpja")
    public suspend fun configured(`value`: Output<Boolean>) {
        this.configured = value
    }

    /**
     * @param value If set to `true`, the launched EC2 instance will hibernation enabled.
     */
    @JvmName("vhevdvmhwvoroeje")
    public suspend fun configured(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configured = mapped
    }

    internal fun build(): LaunchTemplateHibernationOptionsArgs = LaunchTemplateHibernationOptionsArgs(
        configured = configured ?: throw PulumiNullFieldException("configured"),
    )
}
