@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.LaunchTemplateInstanceRequirementsMemoryMibArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property max Maximum.
 * @property min Minimum.
 */
public data class LaunchTemplateInstanceRequirementsMemoryMibArgs(
    public val max: Output<Int>? = null,
    public val min: Output<Int>,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.LaunchTemplateInstanceRequirementsMemoryMibArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.LaunchTemplateInstanceRequirementsMemoryMibArgs =
        com.pulumi.aws.ec2.inputs.LaunchTemplateInstanceRequirementsMemoryMibArgs.builder()
            .max(max?.applyValue({ args0 -> args0 }))
            .min(min.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LaunchTemplateInstanceRequirementsMemoryMibArgs].
 */
@PulumiTagMarker
public class LaunchTemplateInstanceRequirementsMemoryMibArgsBuilder internal constructor() {
    private var max: Output<Int>? = null

    private var min: Output<Int>? = null

    /**
     * @param value Maximum.
     */
    @JvmName("gxrodoiddeuhrjvu")
    public suspend fun max(`value`: Output<Int>) {
        this.max = value
    }

    /**
     * @param value Minimum.
     */
    @JvmName("expvqvtuybncjmyg")
    public suspend fun min(`value`: Output<Int>) {
        this.min = value
    }

    /**
     * @param value Maximum.
     */
    @JvmName("ouygkosdmmctdvas")
    public suspend fun max(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.max = mapped
    }

    /**
     * @param value Minimum.
     */
    @JvmName("wohsilssicpvhkou")
    public suspend fun min(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.min = mapped
    }

    internal fun build(): LaunchTemplateInstanceRequirementsMemoryMibArgs =
        LaunchTemplateInstanceRequirementsMemoryMibArgs(
            max = max,
            min = min ?: throw PulumiNullFieldException("min"),
        )
}
