@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.LaunchTemplateMetadataOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property httpEndpoint Whether the metadata service is available. Can be `"enabled"` or `"disabled"`. (Default: `"enabled"`).
 * @property httpProtocolIpv6 Enables or disables the IPv6 endpoint for the instance metadata service. Can be `"enabled"` or `"disabled"`.
 * @property httpPutResponseHopLimit The desired HTTP PUT response hop limit for instance metadata requests. The larger the number, the further instance metadata requests can travel. Can be an integer from `1` to `64`. (Default: `1`).
 * @property httpTokens Whether or not the metadata service requires session tokens, also referred to as _Instance Metadata Service Version 2 (IMDSv2)_. Can be `"optional"` or `"required"`. (Default: `"optional"`).
 * @property instanceMetadataTags Enables or disables access to instance tags from the instance metadata service. Can be `"enabled"` or `"disabled"`.
 * For more information, see the documentation on the [Instance Metadata Service](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html).
 */
public data class LaunchTemplateMetadataOptionsArgs(
    public val httpEndpoint: Output<String>? = null,
    public val httpProtocolIpv6: Output<String>? = null,
    public val httpPutResponseHopLimit: Output<Int>? = null,
    public val httpTokens: Output<String>? = null,
    public val instanceMetadataTags: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.LaunchTemplateMetadataOptionsArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.LaunchTemplateMetadataOptionsArgs =
        com.pulumi.aws.ec2.inputs.LaunchTemplateMetadataOptionsArgs.builder()
            .httpEndpoint(httpEndpoint?.applyValue({ args0 -> args0 }))
            .httpProtocolIpv6(httpProtocolIpv6?.applyValue({ args0 -> args0 }))
            .httpPutResponseHopLimit(httpPutResponseHopLimit?.applyValue({ args0 -> args0 }))
            .httpTokens(httpTokens?.applyValue({ args0 -> args0 }))
            .instanceMetadataTags(instanceMetadataTags?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LaunchTemplateMetadataOptionsArgs].
 */
@PulumiTagMarker
public class LaunchTemplateMetadataOptionsArgsBuilder internal constructor() {
    private var httpEndpoint: Output<String>? = null

    private var httpProtocolIpv6: Output<String>? = null

    private var httpPutResponseHopLimit: Output<Int>? = null

    private var httpTokens: Output<String>? = null

    private var instanceMetadataTags: Output<String>? = null

    /**
     * @param value Whether the metadata service is available. Can be `"enabled"` or `"disabled"`. (Default: `"enabled"`).
     */
    @JvmName("nembgulnttgxcnrw")
    public suspend fun httpEndpoint(`value`: Output<String>) {
        this.httpEndpoint = value
    }

    /**
     * @param value Enables or disables the IPv6 endpoint for the instance metadata service. Can be `"enabled"` or `"disabled"`.
     */
    @JvmName("fkfjfotrpyugqgdy")
    public suspend fun httpProtocolIpv6(`value`: Output<String>) {
        this.httpProtocolIpv6 = value
    }

    /**
     * @param value The desired HTTP PUT response hop limit for instance metadata requests. The larger the number, the further instance metadata requests can travel. Can be an integer from `1` to `64`. (Default: `1`).
     */
    @JvmName("qjuiwpgchgtxcfeb")
    public suspend fun httpPutResponseHopLimit(`value`: Output<Int>) {
        this.httpPutResponseHopLimit = value
    }

    /**
     * @param value Whether or not the metadata service requires session tokens, also referred to as _Instance Metadata Service Version 2 (IMDSv2)_. Can be `"optional"` or `"required"`. (Default: `"optional"`).
     */
    @JvmName("yqyhdvxmlippyuxy")
    public suspend fun httpTokens(`value`: Output<String>) {
        this.httpTokens = value
    }

    /**
     * @param value Enables or disables access to instance tags from the instance metadata service. Can be `"enabled"` or `"disabled"`.
     * For more information, see the documentation on the [Instance Metadata Service](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html).
     */
    @JvmName("imntdekmlleckjom")
    public suspend fun instanceMetadataTags(`value`: Output<String>) {
        this.instanceMetadataTags = value
    }

    /**
     * @param value Whether the metadata service is available. Can be `"enabled"` or `"disabled"`. (Default: `"enabled"`).
     */
    @JvmName("ewjvvsdhnveucvep")
    public suspend fun httpEndpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpEndpoint = mapped
    }

    /**
     * @param value Enables or disables the IPv6 endpoint for the instance metadata service. Can be `"enabled"` or `"disabled"`.
     */
    @JvmName("ovtpdahshkpdoaya")
    public suspend fun httpProtocolIpv6(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpProtocolIpv6 = mapped
    }

    /**
     * @param value The desired HTTP PUT response hop limit for instance metadata requests. The larger the number, the further instance metadata requests can travel. Can be an integer from `1` to `64`. (Default: `1`).
     */
    @JvmName("ovmewrplqdpueibd")
    public suspend fun httpPutResponseHopLimit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpPutResponseHopLimit = mapped
    }

    /**
     * @param value Whether or not the metadata service requires session tokens, also referred to as _Instance Metadata Service Version 2 (IMDSv2)_. Can be `"optional"` or `"required"`. (Default: `"optional"`).
     */
    @JvmName("tyquobkhkxyoqppd")
    public suspend fun httpTokens(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpTokens = mapped
    }

    /**
     * @param value Enables or disables access to instance tags from the instance metadata service. Can be `"enabled"` or `"disabled"`.
     * For more information, see the documentation on the [Instance Metadata Service](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html).
     */
    @JvmName("ryvotflbipsxrngt")
    public suspend fun instanceMetadataTags(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceMetadataTags = mapped
    }

    internal fun build(): LaunchTemplateMetadataOptionsArgs = LaunchTemplateMetadataOptionsArgs(
        httpEndpoint = httpEndpoint,
        httpProtocolIpv6 = httpProtocolIpv6,
        httpPutResponseHopLimit = httpPutResponseHopLimit,
        httpTokens = httpTokens,
        instanceMetadataTags = instanceMetadataTags,
    )
}
