@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.LaunchTemplateMonitoringArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enabled If `true`, the launched EC2 instance will have detailed monitoring enabled.
 */
public data class LaunchTemplateMonitoringArgs(
    public val enabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.LaunchTemplateMonitoringArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.LaunchTemplateMonitoringArgs =
        com.pulumi.aws.ec2.inputs.LaunchTemplateMonitoringArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LaunchTemplateMonitoringArgs].
 */
@PulumiTagMarker
public class LaunchTemplateMonitoringArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    /**
     * @param value If `true`, the launched EC2 instance will have detailed monitoring enabled.
     */
    @JvmName("mukigfryqkfyrnfx")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value If `true`, the launched EC2 instance will have detailed monitoring enabled.
     */
    @JvmName("sydjlqrbuttwqilw")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    internal fun build(): LaunchTemplateMonitoringArgs = LaunchTemplateMonitoringArgs(
        enabled = enabled,
    )
}
