@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.NetworkInterfaceAttachmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property attachmentId
 * @property deviceIndex Integer to define the devices index.
 * @property instance ID of the instance to attach to.
 */
public data class NetworkInterfaceAttachmentArgs(
    public val attachmentId: Output<String>? = null,
    public val deviceIndex: Output<Int>,
    public val instance: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.NetworkInterfaceAttachmentArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.NetworkInterfaceAttachmentArgs =
        com.pulumi.aws.ec2.inputs.NetworkInterfaceAttachmentArgs.builder()
            .attachmentId(attachmentId?.applyValue({ args0 -> args0 }))
            .deviceIndex(deviceIndex.applyValue({ args0 -> args0 }))
            .instance(instance.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NetworkInterfaceAttachmentArgs].
 */
@PulumiTagMarker
public class NetworkInterfaceAttachmentArgsBuilder internal constructor() {
    private var attachmentId: Output<String>? = null

    private var deviceIndex: Output<Int>? = null

    private var instance: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("yypnlxvfvuhscsdy")
    public suspend fun attachmentId(`value`: Output<String>) {
        this.attachmentId = value
    }

    /**
     * @param value Integer to define the devices index.
     */
    @JvmName("oenqxnvthltdsmbk")
    public suspend fun deviceIndex(`value`: Output<Int>) {
        this.deviceIndex = value
    }

    /**
     * @param value ID of the instance to attach to.
     */
    @JvmName("dtwxunxdatqfqthp")
    public suspend fun instance(`value`: Output<String>) {
        this.instance = value
    }

    /**
     * @param value
     */
    @JvmName("bakggwgnvstmjeib")
    public suspend fun attachmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attachmentId = mapped
    }

    /**
     * @param value Integer to define the devices index.
     */
    @JvmName("vsduhyogehylshet")
    public suspend fun deviceIndex(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deviceIndex = mapped
    }

    /**
     * @param value ID of the instance to attach to.
     */
    @JvmName("jrgirolvgjeyqejd")
    public suspend fun instance(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instance = mapped
    }

    internal fun build(): NetworkInterfaceAttachmentArgs = NetworkInterfaceAttachmentArgs(
        attachmentId = attachmentId,
        deviceIndex = deviceIndex ?: throw PulumiNullFieldException("deviceIndex"),
        instance = instance ?: throw PulumiNullFieldException("instance"),
    )
}
