@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.PeeringConnectionOptionsRequesterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property allowRemoteVpcDnsResolution Allow a local VPC to resolve public DNS hostnames to private IP addresses when queried from instances in the peer VPC.
 */
public data class PeeringConnectionOptionsRequesterArgs(
    public val allowRemoteVpcDnsResolution: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.PeeringConnectionOptionsRequesterArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.PeeringConnectionOptionsRequesterArgs =
        com.pulumi.aws.ec2.inputs.PeeringConnectionOptionsRequesterArgs.builder()
            .allowRemoteVpcDnsResolution(allowRemoteVpcDnsResolution?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PeeringConnectionOptionsRequesterArgs].
 */
@PulumiTagMarker
public class PeeringConnectionOptionsRequesterArgsBuilder internal constructor() {
    private var allowRemoteVpcDnsResolution: Output<Boolean>? = null

    /**
     * @param value Allow a local VPC to resolve public DNS hostnames to private IP addresses when queried from instances in the peer VPC.
     */
    @JvmName("bevvjgqrjrynbtax")
    public suspend fun allowRemoteVpcDnsResolution(`value`: Output<Boolean>) {
        this.allowRemoteVpcDnsResolution = value
    }

    /**
     * @param value Allow a local VPC to resolve public DNS hostnames to private IP addresses when queried from instances in the peer VPC.
     */
    @JvmName("lypcphrkhxtaysrg")
    public suspend fun allowRemoteVpcDnsResolution(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowRemoteVpcDnsResolution = mapped
    }

    internal fun build(): PeeringConnectionOptionsRequesterArgs =
        PeeringConnectionOptionsRequesterArgs(
            allowRemoteVpcDnsResolution = allowRemoteVpcDnsResolution,
        )
}
