@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.SecurityGroupIngressArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property cidrBlocks List of CIDR blocks.
 * @property description Description of this ingress rule.
 * @property fromPort Start port (or ICMP type number if protocol is `icmp` or `icmpv6`).
 * @property ipv6CidrBlocks List of IPv6 CIDR blocks.
 * @property prefixListIds List of Prefix List IDs.
 * @property protocol Protocol. If you select a protocol of `-1` (semantically equivalent to `all`, which is not a valid value here), you must specify a `from_port` and `to_port` equal to 0. The supported values are defined in the `IpProtocol` argument on the [IpPermission](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_IpPermission.html) API reference.
 * The following arguments are optional:
 * > **Note** Although `cidr_blocks`, `ipv6_cidr_blocks`, `prefix_list_ids`, and `security_groups` are all marked as optional, you _must_ provide one of them in order to configure the source of the traffic.
 * @property securityGroups List of security groups. A group name can be used relative to the default VPC. Otherwise, group ID.
 * @property self Whether the security group itself will be added as a source to this ingress rule.
 * @property toPort End range port (or ICMP code if protocol is `icmp`).
 */
public data class SecurityGroupIngressArgs(
    public val cidrBlocks: Output<List<String>>? = null,
    public val description: Output<String>? = null,
    public val fromPort: Output<Int>,
    public val ipv6CidrBlocks: Output<List<String>>? = null,
    public val prefixListIds: Output<List<String>>? = null,
    public val protocol: Output<String>,
    public val securityGroups: Output<List<String>>? = null,
    public val self: Output<Boolean>? = null,
    public val toPort: Output<Int>,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.SecurityGroupIngressArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.SecurityGroupIngressArgs =
        com.pulumi.aws.ec2.inputs.SecurityGroupIngressArgs.builder()
            .cidrBlocks(cidrBlocks?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .fromPort(fromPort.applyValue({ args0 -> args0 }))
            .ipv6CidrBlocks(ipv6CidrBlocks?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .prefixListIds(prefixListIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .protocol(protocol.applyValue({ args0 -> args0 }))
            .securityGroups(securityGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .self(self?.applyValue({ args0 -> args0 }))
            .toPort(toPort.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SecurityGroupIngressArgs].
 */
@PulumiTagMarker
public class SecurityGroupIngressArgsBuilder internal constructor() {
    private var cidrBlocks: Output<List<String>>? = null

    private var description: Output<String>? = null

    private var fromPort: Output<Int>? = null

    private var ipv6CidrBlocks: Output<List<String>>? = null

    private var prefixListIds: Output<List<String>>? = null

    private var protocol: Output<String>? = null

    private var securityGroups: Output<List<String>>? = null

    private var self: Output<Boolean>? = null

    private var toPort: Output<Int>? = null

    /**
     * @param value List of CIDR blocks.
     */
    @JvmName("cphtocecfvoomcei")
    public suspend fun cidrBlocks(`value`: Output<List<String>>) {
        this.cidrBlocks = value
    }

    @JvmName("boktufbkxjgnukib")
    public suspend fun cidrBlocks(vararg values: Output<String>) {
        this.cidrBlocks = Output.all(values.asList())
    }

    /**
     * @param values List of CIDR blocks.
     */
    @JvmName("psebrgkubqkjibds")
    public suspend fun cidrBlocks(values: List<Output<String>>) {
        this.cidrBlocks = Output.all(values)
    }

    /**
     * @param value Description of this ingress rule.
     */
    @JvmName("cvqlctqlbysjdrjd")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Start port (or ICMP type number if protocol is `icmp` or `icmpv6`).
     */
    @JvmName("ghvvfhrxeeflnmyr")
    public suspend fun fromPort(`value`: Output<Int>) {
        this.fromPort = value
    }

    /**
     * @param value List of IPv6 CIDR blocks.
     */
    @JvmName("sjbmtjdratlbqnbf")
    public suspend fun ipv6CidrBlocks(`value`: Output<List<String>>) {
        this.ipv6CidrBlocks = value
    }

    @JvmName("bmexvrkloyqbutkg")
    public suspend fun ipv6CidrBlocks(vararg values: Output<String>) {
        this.ipv6CidrBlocks = Output.all(values.asList())
    }

    /**
     * @param values List of IPv6 CIDR blocks.
     */
    @JvmName("norqrvnjlhfavair")
    public suspend fun ipv6CidrBlocks(values: List<Output<String>>) {
        this.ipv6CidrBlocks = Output.all(values)
    }

    /**
     * @param value List of Prefix List IDs.
     */
    @JvmName("pvcbptwpksktvkeg")
    public suspend fun prefixListIds(`value`: Output<List<String>>) {
        this.prefixListIds = value
    }

    @JvmName("aqopwcyytqxqaqgo")
    public suspend fun prefixListIds(vararg values: Output<String>) {
        this.prefixListIds = Output.all(values.asList())
    }

    /**
     * @param values List of Prefix List IDs.
     */
    @JvmName("detitbywrgforgmx")
    public suspend fun prefixListIds(values: List<Output<String>>) {
        this.prefixListIds = Output.all(values)
    }

    /**
     * @param value Protocol. If you select a protocol of `-1` (semantically equivalent to `all`, which is not a valid value here), you must specify a `from_port` and `to_port` equal to 0. The supported values are defined in the `IpProtocol` argument on the [IpPermission](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_IpPermission.html) API reference.
     * The following arguments are optional:
     * > **Note** Although `cidr_blocks`, `ipv6_cidr_blocks`, `prefix_list_ids`, and `security_groups` are all marked as optional, you _must_ provide one of them in order to configure the source of the traffic.
     */
    @JvmName("yvibnpjpqqjyucmj")
    public suspend fun protocol(`value`: Output<String>) {
        this.protocol = value
    }

    /**
     * @param value List of security groups. A group name can be used relative to the default VPC. Otherwise, group ID.
     */
    @JvmName("bmsbvvxcldndkrlf")
    public suspend fun securityGroups(`value`: Output<List<String>>) {
        this.securityGroups = value
    }

    @JvmName("krghilesdpshcpbo")
    public suspend fun securityGroups(vararg values: Output<String>) {
        this.securityGroups = Output.all(values.asList())
    }

    /**
     * @param values List of security groups. A group name can be used relative to the default VPC. Otherwise, group ID.
     */
    @JvmName("rmhqhkelkpmmgugr")
    public suspend fun securityGroups(values: List<Output<String>>) {
        this.securityGroups = Output.all(values)
    }

    /**
     * @param value Whether the security group itself will be added as a source to this ingress rule.
     */
    @JvmName("lpgloyeimgctjwjs")
    public suspend fun self(`value`: Output<Boolean>) {
        this.self = value
    }

    /**
     * @param value End range port (or ICMP code if protocol is `icmp`).
     */
    @JvmName("lvoteiqsneyqllio")
    public suspend fun toPort(`value`: Output<Int>) {
        this.toPort = value
    }

    /**
     * @param value List of CIDR blocks.
     */
    @JvmName("tdlvhyitkygbwfun")
    public suspend fun cidrBlocks(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cidrBlocks = mapped
    }

    /**
     * @param values List of CIDR blocks.
     */
    @JvmName("qgmbkqjoxobykfic")
    public suspend fun cidrBlocks(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cidrBlocks = mapped
    }

    /**
     * @param value Description of this ingress rule.
     */
    @JvmName("rcwerabcxoakcmny")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Start port (or ICMP type number if protocol is `icmp` or `icmpv6`).
     */
    @JvmName("otlvhreyinilearh")
    public suspend fun fromPort(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fromPort = mapped
    }

    /**
     * @param value List of IPv6 CIDR blocks.
     */
    @JvmName("vbouldkppcoqeybv")
    public suspend fun ipv6CidrBlocks(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6CidrBlocks = mapped
    }

    /**
     * @param values List of IPv6 CIDR blocks.
     */
    @JvmName("naomicvslyuybojy")
    public suspend fun ipv6CidrBlocks(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipv6CidrBlocks = mapped
    }

    /**
     * @param value List of Prefix List IDs.
     */
    @JvmName("wusfbmhuhumephna")
    public suspend fun prefixListIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefixListIds = mapped
    }

    /**
     * @param values List of Prefix List IDs.
     */
    @JvmName("aemyxynwfgtgxyin")
    public suspend fun prefixListIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.prefixListIds = mapped
    }

    /**
     * @param value Protocol. If you select a protocol of `-1` (semantically equivalent to `all`, which is not a valid value here), you must specify a `from_port` and `to_port` equal to 0. The supported values are defined in the `IpProtocol` argument on the [IpPermission](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_IpPermission.html) API reference.
     * The following arguments are optional:
     * > **Note** Although `cidr_blocks`, `ipv6_cidr_blocks`, `prefix_list_ids`, and `security_groups` are all marked as optional, you _must_ provide one of them in order to configure the source of the traffic.
     */
    @JvmName("ygnruobxcfvwjtws")
    public suspend fun protocol(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value List of security groups. A group name can be used relative to the default VPC. Otherwise, group ID.
     */
    @JvmName("nniovkpxmwqvodml")
    public suspend fun securityGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroups = mapped
    }

    /**
     * @param values List of security groups. A group name can be used relative to the default VPC. Otherwise, group ID.
     */
    @JvmName("gmtyyfpopjeajvmv")
    public suspend fun securityGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroups = mapped
    }

    /**
     * @param value Whether the security group itself will be added as a source to this ingress rule.
     */
    @JvmName("chswotircorrebih")
    public suspend fun self(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.self = mapped
    }

    /**
     * @param value End range port (or ICMP code if protocol is `icmp`).
     */
    @JvmName("kbdtyfmwusnelngf")
    public suspend fun toPort(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.toPort = mapped
    }

    internal fun build(): SecurityGroupIngressArgs = SecurityGroupIngressArgs(
        cidrBlocks = cidrBlocks,
        description = description,
        fromPort = fromPort ?: throw PulumiNullFieldException("fromPort"),
        ipv6CidrBlocks = ipv6CidrBlocks,
        prefixListIds = prefixListIds,
        protocol = protocol ?: throw PulumiNullFieldException("protocol"),
        securityGroups = securityGroups,
        self = self,
        toPort = toPort ?: throw PulumiNullFieldException("toPort"),
    )
}
