@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.SpotFleetRequestLaunchSpecificationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property ami
 * @property associatePublicIpAddress
 * @property availabilityZone The availability zone in which to place the request.
 * @property ebsBlockDevices
 * @property ebsOptimized
 * @property ephemeralBlockDevices
 * @property iamInstanceProfile
 * @property iamInstanceProfileArn
 * @property instanceType The type of instance to request.
 * @property keyName
 * @property monitoring
 * @property placementGroup
 * @property placementTenancy
 * @property rootBlockDevices
 * @property spotPrice The maximum bid price per unit hour.
 * @property subnetId The subnet in which to launch the requested instance.
 * @property tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property userData
 * @property vpcSecurityGroupIds
 * @property weightedCapacity The capacity added to the fleet by a fulfilled request.
 */
public data class SpotFleetRequestLaunchSpecificationArgs(
    public val ami: Output<String>,
    public val associatePublicIpAddress: Output<Boolean>? = null,
    public val availabilityZone: Output<String>? = null,
    public val ebsBlockDevices: Output<List<SpotFleetRequestLaunchSpecificationEbsBlockDeviceArgs>>? =
        null,
    public val ebsOptimized: Output<Boolean>? = null,
    public val ephemeralBlockDevices: Output<List<SpotFleetRequestLaunchSpecificationEphemeralBlockDeviceArgs>>? = null,
    public val iamInstanceProfile: Output<String>? = null,
    public val iamInstanceProfileArn: Output<String>? = null,
    public val instanceType: Output<String>,
    public val keyName: Output<String>? = null,
    public val monitoring: Output<Boolean>? = null,
    public val placementGroup: Output<String>? = null,
    public val placementTenancy: Output<String>? = null,
    public val rootBlockDevices: Output<List<SpotFleetRequestLaunchSpecificationRootBlockDeviceArgs>>? =
        null,
    public val spotPrice: Output<String>? = null,
    public val subnetId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val userData: Output<String>? = null,
    public val vpcSecurityGroupIds: Output<List<String>>? = null,
    public val weightedCapacity: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.SpotFleetRequestLaunchSpecificationArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.SpotFleetRequestLaunchSpecificationArgs =
        com.pulumi.aws.ec2.inputs.SpotFleetRequestLaunchSpecificationArgs.builder()
            .ami(ami.applyValue({ args0 -> args0 }))
            .associatePublicIpAddress(associatePublicIpAddress?.applyValue({ args0 -> args0 }))
            .availabilityZone(availabilityZone?.applyValue({ args0 -> args0 }))
            .ebsBlockDevices(
                ebsBlockDevices?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ebsOptimized(ebsOptimized?.applyValue({ args0 -> args0 }))
            .ephemeralBlockDevices(
                ephemeralBlockDevices?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .iamInstanceProfile(iamInstanceProfile?.applyValue({ args0 -> args0 }))
            .iamInstanceProfileArn(iamInstanceProfileArn?.applyValue({ args0 -> args0 }))
            .instanceType(instanceType.applyValue({ args0 -> args0 }))
            .keyName(keyName?.applyValue({ args0 -> args0 }))
            .monitoring(monitoring?.applyValue({ args0 -> args0 }))
            .placementGroup(placementGroup?.applyValue({ args0 -> args0 }))
            .placementTenancy(placementTenancy?.applyValue({ args0 -> args0 }))
            .rootBlockDevices(
                rootBlockDevices?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .spotPrice(spotPrice?.applyValue({ args0 -> args0 }))
            .subnetId(subnetId?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .userData(userData?.applyValue({ args0 -> args0 }))
            .vpcSecurityGroupIds(vpcSecurityGroupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .weightedCapacity(weightedCapacity?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SpotFleetRequestLaunchSpecificationArgs].
 */
@PulumiTagMarker
public class SpotFleetRequestLaunchSpecificationArgsBuilder internal constructor() {
    private var ami: Output<String>? = null

    private var associatePublicIpAddress: Output<Boolean>? = null

    private var availabilityZone: Output<String>? = null

    private var ebsBlockDevices: Output<List<SpotFleetRequestLaunchSpecificationEbsBlockDeviceArgs>>? =
        null

    private var ebsOptimized: Output<Boolean>? = null

    private var ephemeralBlockDevices:
        Output<List<SpotFleetRequestLaunchSpecificationEphemeralBlockDeviceArgs>>? = null

    private var iamInstanceProfile: Output<String>? = null

    private var iamInstanceProfileArn: Output<String>? = null

    private var instanceType: Output<String>? = null

    private var keyName: Output<String>? = null

    private var monitoring: Output<Boolean>? = null

    private var placementGroup: Output<String>? = null

    private var placementTenancy: Output<String>? = null

    private var rootBlockDevices:
        Output<List<SpotFleetRequestLaunchSpecificationRootBlockDeviceArgs>>? = null

    private var spotPrice: Output<String>? = null

    private var subnetId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var userData: Output<String>? = null

    private var vpcSecurityGroupIds: Output<List<String>>? = null

    private var weightedCapacity: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("vcbmcebamamuujpw")
    public suspend fun ami(`value`: Output<String>) {
        this.ami = value
    }

    /**
     * @param value
     */
    @JvmName("hojpslkgtxgqcstb")
    public suspend fun associatePublicIpAddress(`value`: Output<Boolean>) {
        this.associatePublicIpAddress = value
    }

    /**
     * @param value The availability zone in which to place the request.
     */
    @JvmName("kjqhewnaibadrspo")
    public suspend fun availabilityZone(`value`: Output<String>) {
        this.availabilityZone = value
    }

    /**
     * @param value
     */
    @JvmName("qkpfdctsriwhfuoi")
    public suspend fun ebsBlockDevices(`value`: Output<List<SpotFleetRequestLaunchSpecificationEbsBlockDeviceArgs>>) {
        this.ebsBlockDevices = value
    }

    @JvmName("pdaktarobqprdqdc")
    public suspend fun ebsBlockDevices(vararg values: Output<SpotFleetRequestLaunchSpecificationEbsBlockDeviceArgs>) {
        this.ebsBlockDevices = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("upaiwuowewjxelxc")
    public suspend fun ebsBlockDevices(values: List<Output<SpotFleetRequestLaunchSpecificationEbsBlockDeviceArgs>>) {
        this.ebsBlockDevices = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("ugqqcdgagalburqt")
    public suspend fun ebsOptimized(`value`: Output<Boolean>) {
        this.ebsOptimized = value
    }

    /**
     * @param value
     */
    @JvmName("rmgpgbhnbgkbfcli")
    public suspend fun ephemeralBlockDevices(`value`: Output<List<SpotFleetRequestLaunchSpecificationEphemeralBlockDeviceArgs>>) {
        this.ephemeralBlockDevices = value
    }

    @JvmName("dmmrhltjdvasjikg")
    public suspend fun ephemeralBlockDevices(vararg values: Output<SpotFleetRequestLaunchSpecificationEphemeralBlockDeviceArgs>) {
        this.ephemeralBlockDevices = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("npyuowokkgbwukpd")
    public suspend fun ephemeralBlockDevices(values: List<Output<SpotFleetRequestLaunchSpecificationEphemeralBlockDeviceArgs>>) {
        this.ephemeralBlockDevices = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("tdswnudalwggpdpf")
    public suspend fun iamInstanceProfile(`value`: Output<String>) {
        this.iamInstanceProfile = value
    }

    /**
     * @param value
     */
    @JvmName("kedrqevpkqmbbomf")
    public suspend fun iamInstanceProfileArn(`value`: Output<String>) {
        this.iamInstanceProfileArn = value
    }

    /**
     * @param value The type of instance to request.
     */
    @JvmName("fhdggxrcqnutflxd")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value
     */
    @JvmName("lnkcuiddxwgxhawe")
    public suspend fun keyName(`value`: Output<String>) {
        this.keyName = value
    }

    /**
     * @param value
     */
    @JvmName("ajyjhddjqfjvafej")
    public suspend fun monitoring(`value`: Output<Boolean>) {
        this.monitoring = value
    }

    /**
     * @param value
     */
    @JvmName("ustoicjtrugttddv")
    public suspend fun placementGroup(`value`: Output<String>) {
        this.placementGroup = value
    }

    /**
     * @param value
     */
    @JvmName("quwohxhnichgescf")
    public suspend fun placementTenancy(`value`: Output<String>) {
        this.placementTenancy = value
    }

    /**
     * @param value
     */
    @JvmName("wogtneydtwrqkocg")
    public suspend fun rootBlockDevices(`value`: Output<List<SpotFleetRequestLaunchSpecificationRootBlockDeviceArgs>>) {
        this.rootBlockDevices = value
    }

    @JvmName("aeypsjognnndwlqi")
    public suspend fun rootBlockDevices(vararg values: Output<SpotFleetRequestLaunchSpecificationRootBlockDeviceArgs>) {
        this.rootBlockDevices = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("dxvxewdlcwmgcxvl")
    public suspend fun rootBlockDevices(values: List<Output<SpotFleetRequestLaunchSpecificationRootBlockDeviceArgs>>) {
        this.rootBlockDevices = Output.all(values)
    }

    /**
     * @param value The maximum bid price per unit hour.
     */
    @JvmName("suxvltcxppqyhhlh")
    public suspend fun spotPrice(`value`: Output<String>) {
        this.spotPrice = value
    }

    /**
     * @param value The subnet in which to launch the requested instance.
     */
    @JvmName("scvapdnjvgmrccog")
    public suspend fun subnetId(`value`: Output<String>) {
        this.subnetId = value
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mildquvajklachyq")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("nlcivqhpwpxlxqll")
    public suspend fun userData(`value`: Output<String>) {
        this.userData = value
    }

    /**
     * @param value
     */
    @JvmName("ynsannrynslbmgir")
    public suspend fun vpcSecurityGroupIds(`value`: Output<List<String>>) {
        this.vpcSecurityGroupIds = value
    }

    @JvmName("ronqkdijggqmpvvc")
    public suspend fun vpcSecurityGroupIds(vararg values: Output<String>) {
        this.vpcSecurityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("xghorsgjlgkpfjtx")
    public suspend fun vpcSecurityGroupIds(values: List<Output<String>>) {
        this.vpcSecurityGroupIds = Output.all(values)
    }

    /**
     * @param value The capacity added to the fleet by a fulfilled request.
     */
    @JvmName("uwgimyxelgrkmttl")
    public suspend fun weightedCapacity(`value`: Output<String>) {
        this.weightedCapacity = value
    }

    /**
     * @param value
     */
    @JvmName("awlvoaysxucodasx")
    public suspend fun ami(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ami = mapped
    }

    /**
     * @param value
     */
    @JvmName("ecigrtripaadqakm")
    public suspend fun associatePublicIpAddress(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.associatePublicIpAddress = mapped
    }

    /**
     * @param value The availability zone in which to place the request.
     */
    @JvmName("tlvxleeqxurbngal")
    public suspend fun availabilityZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityZone = mapped
    }

    /**
     * @param value
     */
    @JvmName("wmyndhqwwqemtpud")
    public suspend fun ebsBlockDevices(`value`: List<SpotFleetRequestLaunchSpecificationEbsBlockDeviceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ebsBlockDevices = mapped
    }

    /**
     * @param argument
     */
    @JvmName("lkigyvrlgkvutrxb")
    public suspend fun ebsBlockDevices(argument: List<suspend SpotFleetRequestLaunchSpecificationEbsBlockDeviceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SpotFleetRequestLaunchSpecificationEbsBlockDeviceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ebsBlockDevices = mapped
    }

    /**
     * @param argument
     */
    @JvmName("siwfrfdctyksswvy")
    public suspend fun ebsBlockDevices(vararg argument: suspend SpotFleetRequestLaunchSpecificationEbsBlockDeviceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            SpotFleetRequestLaunchSpecificationEbsBlockDeviceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ebsBlockDevices = mapped
    }

    /**
     * @param argument
     */
    @JvmName("igknlqdlavadxkbp")
    public suspend fun ebsBlockDevices(argument: suspend SpotFleetRequestLaunchSpecificationEbsBlockDeviceArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                SpotFleetRequestLaunchSpecificationEbsBlockDeviceArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.ebsBlockDevices = mapped
    }

    /**
     * @param values
     */
    @JvmName("yvypfktoyokfbtet")
    public suspend fun ebsBlockDevices(vararg values: SpotFleetRequestLaunchSpecificationEbsBlockDeviceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ebsBlockDevices = mapped
    }

    /**
     * @param value
     */
    @JvmName("oqjlviprvpklksum")
    public suspend fun ebsOptimized(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ebsOptimized = mapped
    }

    /**
     * @param value
     */
    @JvmName("riavbavhwrbdtsan")
    public suspend fun ephemeralBlockDevices(`value`: List<SpotFleetRequestLaunchSpecificationEphemeralBlockDeviceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ephemeralBlockDevices = mapped
    }

    /**
     * @param argument
     */
    @JvmName("lonsltcjfpigafhn")
    public suspend fun ephemeralBlockDevices(argument: List<suspend SpotFleetRequestLaunchSpecificationEphemeralBlockDeviceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SpotFleetRequestLaunchSpecificationEphemeralBlockDeviceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ephemeralBlockDevices = mapped
    }

    /**
     * @param argument
     */
    @JvmName("xtptwcawnkinxojy")
    public suspend fun ephemeralBlockDevices(vararg argument: suspend SpotFleetRequestLaunchSpecificationEphemeralBlockDeviceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            SpotFleetRequestLaunchSpecificationEphemeralBlockDeviceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ephemeralBlockDevices = mapped
    }

    /**
     * @param argument
     */
    @JvmName("hosvsxdsunpmamnx")
    public suspend fun ephemeralBlockDevices(argument: suspend SpotFleetRequestLaunchSpecificationEphemeralBlockDeviceArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                SpotFleetRequestLaunchSpecificationEphemeralBlockDeviceArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.ephemeralBlockDevices = mapped
    }

    /**
     * @param values
     */
    @JvmName("ardhdjabqpvfodkw")
    public suspend fun ephemeralBlockDevices(vararg values: SpotFleetRequestLaunchSpecificationEphemeralBlockDeviceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ephemeralBlockDevices = mapped
    }

    /**
     * @param value
     */
    @JvmName("wvfkfpeflflgsdnv")
    public suspend fun iamInstanceProfile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iamInstanceProfile = mapped
    }

    /**
     * @param value
     */
    @JvmName("mmxxatknqhbbqcba")
    public suspend fun iamInstanceProfileArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iamInstanceProfileArn = mapped
    }

    /**
     * @param value The type of instance to request.
     */
    @JvmName("bcohdikejjhopnkf")
    public suspend fun instanceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value
     */
    @JvmName("rthsqnyhmgmvwcef")
    public suspend fun keyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyName = mapped
    }

    /**
     * @param value
     */
    @JvmName("dmjvldkcnbsdutcx")
    public suspend fun monitoring(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monitoring = mapped
    }

    /**
     * @param value
     */
    @JvmName("jpiibkqmcrhmikgy")
    public suspend fun placementGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.placementGroup = mapped
    }

    /**
     * @param value
     */
    @JvmName("hlysenptirnlgoce")
    public suspend fun placementTenancy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.placementTenancy = mapped
    }

    /**
     * @param value
     */
    @JvmName("ahsmnxmiboxjcrvf")
    public suspend fun rootBlockDevices(`value`: List<SpotFleetRequestLaunchSpecificationRootBlockDeviceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rootBlockDevices = mapped
    }

    /**
     * @param argument
     */
    @JvmName("dfgwgwyyayfipwwt")
    public suspend fun rootBlockDevices(argument: List<suspend SpotFleetRequestLaunchSpecificationRootBlockDeviceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SpotFleetRequestLaunchSpecificationRootBlockDeviceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.rootBlockDevices = mapped
    }

    /**
     * @param argument
     */
    @JvmName("yqfaunvarenqynld")
    public suspend fun rootBlockDevices(vararg argument: suspend SpotFleetRequestLaunchSpecificationRootBlockDeviceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            SpotFleetRequestLaunchSpecificationRootBlockDeviceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.rootBlockDevices = mapped
    }

    /**
     * @param argument
     */
    @JvmName("rllsyltriqmfdava")
    public suspend fun rootBlockDevices(argument: suspend SpotFleetRequestLaunchSpecificationRootBlockDeviceArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                SpotFleetRequestLaunchSpecificationRootBlockDeviceArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.rootBlockDevices = mapped
    }

    /**
     * @param values
     */
    @JvmName("alklmpjinfhhrkbn")
    public suspend fun rootBlockDevices(vararg values: SpotFleetRequestLaunchSpecificationRootBlockDeviceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rootBlockDevices = mapped
    }

    /**
     * @param value The maximum bid price per unit hour.
     */
    @JvmName("xyaifbswnfsfijhx")
    public suspend fun spotPrice(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spotPrice = mapped
    }

    /**
     * @param value The subnet in which to launch the requested instance.
     */
    @JvmName("owolvuyxmjpoffit")
    public suspend fun subnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetId = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rwvvynausetdoaol")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("iibbuganuawdosym")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value
     */
    @JvmName("fhjotjuumjijtwqp")
    public suspend fun userData(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userData = mapped
    }

    /**
     * @param value
     */
    @JvmName("hhlnopwmjpoebpop")
    public suspend fun vpcSecurityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcSecurityGroupIds = mapped
    }

    /**
     * @param values
     */
    @JvmName("yjigwmerfoktmbxp")
    public suspend fun vpcSecurityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpcSecurityGroupIds = mapped
    }

    /**
     * @param value The capacity added to the fleet by a fulfilled request.
     */
    @JvmName("ohupjnyjdpqudafv")
    public suspend fun weightedCapacity(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weightedCapacity = mapped
    }

    internal fun build(): SpotFleetRequestLaunchSpecificationArgs =
        SpotFleetRequestLaunchSpecificationArgs(
            ami = ami ?: throw PulumiNullFieldException("ami"),
            associatePublicIpAddress = associatePublicIpAddress,
            availabilityZone = availabilityZone,
            ebsBlockDevices = ebsBlockDevices,
            ebsOptimized = ebsOptimized,
            ephemeralBlockDevices = ephemeralBlockDevices,
            iamInstanceProfile = iamInstanceProfile,
            iamInstanceProfileArn = iamInstanceProfileArn,
            instanceType = instanceType ?: throw PulumiNullFieldException("instanceType"),
            keyName = keyName,
            monitoring = monitoring,
            placementGroup = placementGroup,
            placementTenancy = placementTenancy,
            rootBlockDevices = rootBlockDevices,
            spotPrice = spotPrice,
            subnetId = subnetId,
            tags = tags,
            userData = userData,
            vpcSecurityGroupIds = vpcSecurityGroupIds,
            weightedCapacity = weightedCapacity,
        )
}
