@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.SpotFleetRequestLaunchSpecificationEbsBlockDeviceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property deleteOnTermination
 * @property deviceName
 * @property encrypted
 * @property iops
 * @property kmsKeyId
 * @property snapshotId
 * @property throughput
 * @property volumeSize
 * @property volumeType
 */
public data class SpotFleetRequestLaunchSpecificationEbsBlockDeviceArgs(
    public val deleteOnTermination: Output<Boolean>? = null,
    public val deviceName: Output<String>,
    public val encrypted: Output<Boolean>? = null,
    public val iops: Output<Int>? = null,
    public val kmsKeyId: Output<String>? = null,
    public val snapshotId: Output<String>? = null,
    public val throughput: Output<Int>? = null,
    public val volumeSize: Output<Int>? = null,
    public val volumeType: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.ec2.inputs.SpotFleetRequestLaunchSpecificationEbsBlockDeviceArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.SpotFleetRequestLaunchSpecificationEbsBlockDeviceArgs =
        com.pulumi.aws.ec2.inputs.SpotFleetRequestLaunchSpecificationEbsBlockDeviceArgs.builder()
            .deleteOnTermination(deleteOnTermination?.applyValue({ args0 -> args0 }))
            .deviceName(deviceName.applyValue({ args0 -> args0 }))
            .encrypted(encrypted?.applyValue({ args0 -> args0 }))
            .iops(iops?.applyValue({ args0 -> args0 }))
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .snapshotId(snapshotId?.applyValue({ args0 -> args0 }))
            .throughput(throughput?.applyValue({ args0 -> args0 }))
            .volumeSize(volumeSize?.applyValue({ args0 -> args0 }))
            .volumeType(volumeType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SpotFleetRequestLaunchSpecificationEbsBlockDeviceArgs].
 */
@PulumiTagMarker
public class SpotFleetRequestLaunchSpecificationEbsBlockDeviceArgsBuilder internal constructor() {
    private var deleteOnTermination: Output<Boolean>? = null

    private var deviceName: Output<String>? = null

    private var encrypted: Output<Boolean>? = null

    private var iops: Output<Int>? = null

    private var kmsKeyId: Output<String>? = null

    private var snapshotId: Output<String>? = null

    private var throughput: Output<Int>? = null

    private var volumeSize: Output<Int>? = null

    private var volumeType: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("sxiacsvmhnvxhcdt")
    public suspend fun deleteOnTermination(`value`: Output<Boolean>) {
        this.deleteOnTermination = value
    }

    /**
     * @param value
     */
    @JvmName("xcypoyvoqyfguvme")
    public suspend fun deviceName(`value`: Output<String>) {
        this.deviceName = value
    }

    /**
     * @param value
     */
    @JvmName("slapqpaynldlqbug")
    public suspend fun encrypted(`value`: Output<Boolean>) {
        this.encrypted = value
    }

    /**
     * @param value
     */
    @JvmName("umfqjdcwftvrkxkr")
    public suspend fun iops(`value`: Output<Int>) {
        this.iops = value
    }

    /**
     * @param value
     */
    @JvmName("yfcvefbiarehbwsn")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value
     */
    @JvmName("jvktiqggrjyujtat")
    public suspend fun snapshotId(`value`: Output<String>) {
        this.snapshotId = value
    }

    /**
     * @param value
     */
    @JvmName("umbuyxvomttpfnto")
    public suspend fun throughput(`value`: Output<Int>) {
        this.throughput = value
    }

    /**
     * @param value
     */
    @JvmName("gkxafhwjvddbtden")
    public suspend fun volumeSize(`value`: Output<Int>) {
        this.volumeSize = value
    }

    /**
     * @param value
     */
    @JvmName("asiinqclmfyfmswr")
    public suspend fun volumeType(`value`: Output<String>) {
        this.volumeType = value
    }

    /**
     * @param value
     */
    @JvmName("dbgwwdexsdqljocc")
    public suspend fun deleteOnTermination(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteOnTermination = mapped
    }

    /**
     * @param value
     */
    @JvmName("ogjaxljevkeelalj")
    public suspend fun deviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deviceName = mapped
    }

    /**
     * @param value
     */
    @JvmName("fqwfildndsekjvum")
    public suspend fun encrypted(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encrypted = mapped
    }

    /**
     * @param value
     */
    @JvmName("qogqlckgjvpibcpf")
    public suspend fun iops(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iops = mapped
    }

    /**
     * @param value
     */
    @JvmName("hmmcicmdbwywlnol")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value
     */
    @JvmName("ivqjirjvexwkfpcw")
    public suspend fun snapshotId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotId = mapped
    }

    /**
     * @param value
     */
    @JvmName("vrhwwjajkfoasxxg")
    public suspend fun throughput(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.throughput = mapped
    }

    /**
     * @param value
     */
    @JvmName("laycdiknadbamtmb")
    public suspend fun volumeSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeSize = mapped
    }

    /**
     * @param value
     */
    @JvmName("ojcvfbioamjhllwv")
    public suspend fun volumeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeType = mapped
    }

    internal fun build(): SpotFleetRequestLaunchSpecificationEbsBlockDeviceArgs =
        SpotFleetRequestLaunchSpecificationEbsBlockDeviceArgs(
            deleteOnTermination = deleteOnTermination,
            deviceName = deviceName ?: throw PulumiNullFieldException("deviceName"),
            encrypted = encrypted,
            iops = iops,
            kmsKeyId = kmsKeyId,
            snapshotId = snapshotId,
            throughput = throughput,
            volumeSize = volumeSize,
            volumeType = volumeType,
        )
}
