@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.SpotFleetRequestLaunchTemplateConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property launchTemplateSpecification Launch template specification. See Launch Template Specification below for more details.
 * @property overrides One or more override configurations. See Overrides below for more details.
 */
public data class SpotFleetRequestLaunchTemplateConfigArgs(
    public val launchTemplateSpecification: Output<SpotFleetRequestLaunchTemplateConfigLaunchTemplateSpecificationArgs>,
    public val overrides: Output<List<SpotFleetRequestLaunchTemplateConfigOverrideArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.SpotFleetRequestLaunchTemplateConfigArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.SpotFleetRequestLaunchTemplateConfigArgs =
        com.pulumi.aws.ec2.inputs.SpotFleetRequestLaunchTemplateConfigArgs.builder()
            .launchTemplateSpecification(
                launchTemplateSpecification.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .overrides(
                overrides?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [SpotFleetRequestLaunchTemplateConfigArgs].
 */
@PulumiTagMarker
public class SpotFleetRequestLaunchTemplateConfigArgsBuilder internal constructor() {
    private var launchTemplateSpecification:
        Output<SpotFleetRequestLaunchTemplateConfigLaunchTemplateSpecificationArgs>? = null

    private var overrides: Output<List<SpotFleetRequestLaunchTemplateConfigOverrideArgs>>? = null

    /**
     * @param value Launch template specification. See Launch Template Specification below for more details.
     */
    @JvmName("xkcrbwfuerpjrwsj")
    public suspend fun launchTemplateSpecification(`value`: Output<SpotFleetRequestLaunchTemplateConfigLaunchTemplateSpecificationArgs>) {
        this.launchTemplateSpecification = value
    }

    /**
     * @param value One or more override configurations. See Overrides below for more details.
     */
    @JvmName("ajrlbhhleuxujfgm")
    public suspend fun overrides(`value`: Output<List<SpotFleetRequestLaunchTemplateConfigOverrideArgs>>) {
        this.overrides = value
    }

    @JvmName("snjdnaywijwkyghu")
    public suspend fun overrides(vararg values: Output<SpotFleetRequestLaunchTemplateConfigOverrideArgs>) {
        this.overrides = Output.all(values.asList())
    }

    /**
     * @param values One or more override configurations. See Overrides below for more details.
     */
    @JvmName("twatoqacdpsaqrqj")
    public suspend fun overrides(values: List<Output<SpotFleetRequestLaunchTemplateConfigOverrideArgs>>) {
        this.overrides = Output.all(values)
    }

    /**
     * @param value Launch template specification. See Launch Template Specification below for more details.
     */
    @JvmName("xywkcxxabfboenao")
    public suspend fun launchTemplateSpecification(`value`: SpotFleetRequestLaunchTemplateConfigLaunchTemplateSpecificationArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.launchTemplateSpecification = mapped
    }

    /**
     * @param argument Launch template specification. See Launch Template Specification below for more details.
     */
    @JvmName("hqlumiixmmbirggt")
    public suspend fun launchTemplateSpecification(argument: suspend SpotFleetRequestLaunchTemplateConfigLaunchTemplateSpecificationArgsBuilder.() -> Unit) {
        val toBeMapped =
            SpotFleetRequestLaunchTemplateConfigLaunchTemplateSpecificationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.launchTemplateSpecification = mapped
    }

    /**
     * @param value One or more override configurations. See Overrides below for more details.
     */
    @JvmName("qinmtaatmopxksqp")
    public suspend fun overrides(`value`: List<SpotFleetRequestLaunchTemplateConfigOverrideArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.overrides = mapped
    }

    /**
     * @param argument One or more override configurations. See Overrides below for more details.
     */
    @JvmName("etqeldyjrwjdbvie")
    public suspend fun overrides(argument: List<suspend SpotFleetRequestLaunchTemplateConfigOverrideArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SpotFleetRequestLaunchTemplateConfigOverrideArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.overrides = mapped
    }

    /**
     * @param argument One or more override configurations. See Overrides below for more details.
     */
    @JvmName("avctnoxrpxkhrjfh")
    public suspend fun overrides(vararg argument: suspend SpotFleetRequestLaunchTemplateConfigOverrideArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            SpotFleetRequestLaunchTemplateConfigOverrideArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.overrides = mapped
    }

    /**
     * @param argument One or more override configurations. See Overrides below for more details.
     */
    @JvmName("liqccuiukwmkyuhl")
    public suspend fun overrides(argument: suspend SpotFleetRequestLaunchTemplateConfigOverrideArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            SpotFleetRequestLaunchTemplateConfigOverrideArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.overrides = mapped
    }

    /**
     * @param values One or more override configurations. See Overrides below for more details.
     */
    @JvmName("qqqgevhrbewieifl")
    public suspend fun overrides(vararg values: SpotFleetRequestLaunchTemplateConfigOverrideArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.overrides = mapped
    }

    internal fun build(): SpotFleetRequestLaunchTemplateConfigArgs =
        SpotFleetRequestLaunchTemplateConfigArgs(
            launchTemplateSpecification = launchTemplateSpecification ?: throw
                PulumiNullFieldException("launchTemplateSpecification"),
            overrides = overrides,
        )
}
