@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.SpotFleetRequestLaunchTemplateConfigOverrideArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property availabilityZone The availability zone in which to place the request.
 * @property instanceRequirements The instance requirements. See below.
 * @property instanceType The type of instance to request.
 * @property priority The priority for the launch template override. The lower the number, the higher the priority. If no number is set, the launch template override has the lowest priority.
 * @property spotPrice The maximum spot bid for this override request.
 * @property subnetId The subnet in which to launch the requested instance.
 * @property weightedCapacity The capacity added to the fleet by a fulfilled request.
 */
public data class SpotFleetRequestLaunchTemplateConfigOverrideArgs(
    public val availabilityZone: Output<String>? = null,
    public val instanceRequirements: Output<SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsArgs>? = null,
    public val instanceType: Output<String>? = null,
    public val priority: Output<Double>? = null,
    public val spotPrice: Output<String>? = null,
    public val subnetId: Output<String>? = null,
    public val weightedCapacity: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.SpotFleetRequestLaunchTemplateConfigOverrideArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.SpotFleetRequestLaunchTemplateConfigOverrideArgs = com.pulumi.aws.ec2.inputs.SpotFleetRequestLaunchTemplateConfigOverrideArgs.builder()
        .availabilityZone(availabilityZone?.applyValue({ args0 -> args0 }))
        .instanceRequirements(
            instanceRequirements?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        )
        .instanceType(instanceType?.applyValue({ args0 -> args0 }))
        .priority(priority?.applyValue({ args0 -> args0 }))
        .spotPrice(spotPrice?.applyValue({ args0 -> args0 }))
        .subnetId(subnetId?.applyValue({ args0 -> args0 }))
        .weightedCapacity(weightedCapacity?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SpotFleetRequestLaunchTemplateConfigOverrideArgs].
 */
@PulumiTagMarker
public class SpotFleetRequestLaunchTemplateConfigOverrideArgsBuilder internal constructor() {
    private var availabilityZone: Output<String>? = null

    private var instanceRequirements:
        Output<SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsArgs>? = null

    private var instanceType: Output<String>? = null

    private var priority: Output<Double>? = null

    private var spotPrice: Output<String>? = null

    private var subnetId: Output<String>? = null

    private var weightedCapacity: Output<Double>? = null

    /**
     * @param value The availability zone in which to place the request.
     */
    @JvmName("tmhdfkpyrsercaxc")
    public suspend fun availabilityZone(`value`: Output<String>) {
        this.availabilityZone = value
    }

    /**
     * @param value The instance requirements. See below.
     */
    @JvmName("dyjwnyepspuxlyqa")
    public suspend fun instanceRequirements(`value`: Output<SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsArgs>) {
        this.instanceRequirements = value
    }

    /**
     * @param value The type of instance to request.
     */
    @JvmName("iufitwtghwojeudg")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value The priority for the launch template override. The lower the number, the higher the priority. If no number is set, the launch template override has the lowest priority.
     */
    @JvmName("foepbfjauyvdrjou")
    public suspend fun priority(`value`: Output<Double>) {
        this.priority = value
    }

    /**
     * @param value The maximum spot bid for this override request.
     */
    @JvmName("awvvbifsciarfesa")
    public suspend fun spotPrice(`value`: Output<String>) {
        this.spotPrice = value
    }

    /**
     * @param value The subnet in which to launch the requested instance.
     */
    @JvmName("mnkppekovsllwuol")
    public suspend fun subnetId(`value`: Output<String>) {
        this.subnetId = value
    }

    /**
     * @param value The capacity added to the fleet by a fulfilled request.
     */
    @JvmName("xvdcdagwkorfqxrj")
    public suspend fun weightedCapacity(`value`: Output<Double>) {
        this.weightedCapacity = value
    }

    /**
     * @param value The availability zone in which to place the request.
     */
    @JvmName("ditvgurrmpursyuj")
    public suspend fun availabilityZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityZone = mapped
    }

    /**
     * @param value The instance requirements. See below.
     */
    @JvmName("hfgvawoylibtdgqx")
    public suspend fun instanceRequirements(`value`: SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceRequirements = mapped
    }

    /**
     * @param argument The instance requirements. See below.
     */
    @JvmName("qjgnoohpmlqcvehi")
    public suspend fun instanceRequirements(argument: suspend SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsArgsBuilder.() -> Unit) {
        val toBeMapped =
            SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.instanceRequirements = mapped
    }

    /**
     * @param value The type of instance to request.
     */
    @JvmName("jbuofioamaadycyj")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value The priority for the launch template override. The lower the number, the higher the priority. If no number is set, the launch template override has the lowest priority.
     */
    @JvmName("syinyaoixsxmigby")
    public suspend fun priority(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value The maximum spot bid for this override request.
     */
    @JvmName("goyfsmsddcnanpto")
    public suspend fun spotPrice(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spotPrice = mapped
    }

    /**
     * @param value The subnet in which to launch the requested instance.
     */
    @JvmName("cgovvqwjtgugcvkk")
    public suspend fun subnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetId = mapped
    }

    /**
     * @param value The capacity added to the fleet by a fulfilled request.
     */
    @JvmName("rhmlnilwcogycsoo")
    public suspend fun weightedCapacity(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weightedCapacity = mapped
    }

    internal fun build(): SpotFleetRequestLaunchTemplateConfigOverrideArgs =
        SpotFleetRequestLaunchTemplateConfigOverrideArgs(
            availabilityZone = availabilityZone,
            instanceRequirements = instanceRequirements,
            instanceType = instanceType,
            priority = priority,
            spotPrice = spotPrice,
            subnetId = subnetId,
            weightedCapacity = weightedCapacity,
        )
}
