@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property acceleratorCount Block describing the minimum and maximum number of accelerators (GPUs, FPGAs, or AWS Inferentia chips). Default is no minimum or maximum.
 * @property acceleratorManufacturers List of accelerator manufacturer names. Default is any manufacturer.
 * ```
 * Valid names:
 * * amazon-web-services
 * * amd
 * * nvidia
 * * xilinx
 * ```
 * @property acceleratorNames List of accelerator names. Default is any acclerator.
 * ```
 * Valid names:
 * * a100            - NVIDIA A100 GPUs
 * * v100            - NVIDIA V100 GPUs
 * * k80             - NVIDIA K80 GPUs
 * * t4              - NVIDIA T4 GPUs
 * * m60             - NVIDIA M60 GPUs
 * * radeon-pro-v520 - AMD Radeon Pro V520 GPUs
 * * vu9p            - Xilinx VU9P FPGAs
 * ```
 * @property acceleratorTotalMemoryMib Block describing the minimum and maximum total memory of the accelerators. Default is no minimum or maximum.
 * @property acceleratorTypes List of accelerator types. Default is any accelerator type.
 * ```
 * Valid types:
 * * fpga
 * * gpu
 * * inference
 * ```
 * @property allowedInstanceTypes List of instance types to apply your specified attributes against. All other instance types are ignored, even if they match your specified attributes. You can use strings with one or more wild cards, represented by an asterisk (\*), to allow an instance type, size, or generation. The following are examples: `m5.8xlarge`, `c5*.*`, `m5a.*`, `r*`, `*3*`. For example, if you specify `c5*`, you are allowing the entire C5 instance family, which includes all C5a and C5n instance types. If you specify `m5a.*`, you are allowing all the M5a instance types, but not the M5n instance types. Maximum of 400 entries in the list; each entry is limited to 30 characters. Default is all instance types.
 * > **NOTE:** If you specify `allowed_instance_types`, you can't specify `excluded_instance_types`.
 * @property bareMetal Indicate whether bare metal instace types should be `included`, `excluded`, or `required`. Default is `excluded`.
 * @property baselineEbsBandwidthMbps Block describing the minimum and maximum baseline EBS bandwidth, in Mbps. Default is no minimum or maximum.
 * @property burstablePerformance Indicate whether burstable performance instance types should be `included`, `excluded`, or `required`. Default is `excluded`.
 * @property cpuManufacturers List of CPU manufacturer names. Default is any manufacturer.
 * > **NOTE:** Don't confuse the CPU hardware manufacturer with the CPU hardware architecture. Instances will be launched with a compatible CPU architecture based on the Amazon Machine Image (AMI) that you specify in your launch template.
 * ```
 * Valid names:
 * * amazon-web-services
 * * amd
 * * intel
 * ```
 * @property excludedInstanceTypes List of instance types to exclude. You can use strings with one or more wild cards, represented by an asterisk (\*), to exclude an instance type, size, or generation. The following are examples: `m5.8xlarge`, `c5*.*`, `m5a.*`, `r*`, `*3*`. For example, if you specify `c5*`, you are excluding the entire C5 instance family, which includes all C5a and C5n instance types. If you specify `m5a.*`, you are excluding all the M5a instance types, but not the M5n instance types. Maximum of 400 entries in the list; each entry is limited to 30 characters. Default is no excluded instance types.
 * > **NOTE:** If you specify `excluded_instance_types`, you can't specify `allowed_instance_types`.
 * @property instanceGenerations List of instance generation names. Default is any generation.
 * ```
 * Valid names:
 * * current  - Recommended for best performance.
 * * previous - For existing applications optimized for older instance types.
 * ```
 * @property localStorage Indicate whether instance types with local storage volumes are `included`, `excluded`, or `required`. Default is `included`.
 * @property localStorageTypes List of local storage type names. Default any storage type.
 * ```
 * Value names:
 * * hdd - hard disk drive
 * * ssd - solid state drive
 * ```
 * @property memoryGibPerVcpu Block describing the minimum and maximum amount of memory (GiB) per vCPU. Default is no minimum or maximum.
 * @property memoryMib Block describing the minimum and maximum amount of memory (MiB). Default is no maximum.
 * @property networkBandwidthGbps Block describing the minimum and maximum amount of network bandwidth, in gigabits per second (Gbps). Default is no minimum or maximum.
 * @property networkInterfaceCount Block describing the minimum and maximum number of network interfaces. Default is no minimum or maximum.
 * @property onDemandMaxPricePercentageOverLowestPrice The price protection threshold for On-Demand Instances. This is the maximum you’ll pay for an On-Demand Instance, expressed as a percentage higher than the cheapest M, C, or R instance type with your specified attributes. When Amazon EC2 Auto Scaling selects instance types with your attributes, we will exclude instance types whose price is higher than your threshold. The parameter accepts an integer, which Amazon EC2 Auto Scaling interprets as a percentage. To turn off price protection, specify a high value, such as 999999. Default is 20.
 * If you set DesiredCapacityType to vcpu or memory-mib, the price protection threshold is applied based on the per vCPU or per memory price instead of the per instance price.
 * @property requireHibernateSupport Indicate whether instance types must support On-Demand Instance Hibernation, either `true` or `false`. Default is `false`.
 * @property spotMaxPricePercentageOverLowestPrice The price protection threshold for Spot Instances. This is the maximum you’ll pay for a Spot Instance, expressed as a percentage higher than the cheapest M, C, or R instance type with your specified attributes. When Amazon EC2 Auto Scaling selects instance types with your attributes, we will exclude instance types whose price is higher than your threshold. The parameter accepts an integer, which Amazon EC2 Auto Scaling interprets as a percentage. To turn off price protection, specify a high value, such as 999999. Default is 100.
 * If you set DesiredCapacityType to vcpu or memory-mib, the price protection threshold is applied based on the per vCPU or per memory price instead of the per instance price.
 * @property totalLocalStorageGb Block describing the minimum and maximum total local storage (GB). Default is no minimum or maximum.
 * @property vcpuCount Block describing the minimum and maximum number of vCPUs. Default is no maximum.
 */
public data class SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsArgs(
    public val acceleratorCount: Output<SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsAcceleratorCountArgs>? =
        null,
    public val acceleratorManufacturers: Output<List<String>>? = null,
    public val acceleratorNames: Output<List<String>>? = null,
    public val acceleratorTotalMemoryMib: Output<SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsAcceleratorTotalMemoryMibArgs>? =
        null,
    public val acceleratorTypes: Output<List<String>>? = null,
    public val allowedInstanceTypes: Output<List<String>>? = null,
    public val bareMetal: Output<String>? = null,
    public val baselineEbsBandwidthMbps: Output<SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsBaselineEbsBandwidthMbpsArgs>? =
        null,
    public val burstablePerformance: Output<String>? = null,
    public val cpuManufacturers: Output<List<String>>? = null,
    public val excludedInstanceTypes: Output<List<String>>? = null,
    public val instanceGenerations: Output<List<String>>? = null,
    public val localStorage: Output<String>? = null,
    public val localStorageTypes: Output<List<String>>? = null,
    public val memoryGibPerVcpu: Output<SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsMemoryGibPerVcpuArgs>? =
        null,
    public val memoryMib: Output<SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsMemoryMibArgs>? = null,
    public val networkBandwidthGbps: Output<SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsNetworkBandwidthGbpsArgs>? =
        null,
    public val networkInterfaceCount: Output<SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsNetworkInterfaceCountArgs>? =
        null,
    public val onDemandMaxPricePercentageOverLowestPrice: Output<Int>? = null,
    public val requireHibernateSupport: Output<Boolean>? = null,
    public val spotMaxPricePercentageOverLowestPrice: Output<Int>? = null,
    public val totalLocalStorageGb: Output<SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsTotalLocalStorageGbArgs>? =
        null,
    public val vcpuCount: Output<SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsVcpuCountArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.ec2.inputs.SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsArgs =
        com.pulumi.aws.ec2.inputs.SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsArgs.builder()
            .acceleratorCount(acceleratorCount?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .acceleratorManufacturers(
                acceleratorManufacturers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .acceleratorNames(acceleratorNames?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .acceleratorTotalMemoryMib(
                acceleratorTotalMemoryMib?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .acceleratorTypes(acceleratorTypes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .allowedInstanceTypes(allowedInstanceTypes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .bareMetal(bareMetal?.applyValue({ args0 -> args0 }))
            .baselineEbsBandwidthMbps(
                baselineEbsBandwidthMbps?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .burstablePerformance(burstablePerformance?.applyValue({ args0 -> args0 }))
            .cpuManufacturers(cpuManufacturers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .excludedInstanceTypes(excludedInstanceTypes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .instanceGenerations(instanceGenerations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .localStorage(localStorage?.applyValue({ args0 -> args0 }))
            .localStorageTypes(localStorageTypes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .memoryGibPerVcpu(memoryGibPerVcpu?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .memoryMib(memoryMib?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .networkBandwidthGbps(
                networkBandwidthGbps?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .networkInterfaceCount(
                networkInterfaceCount?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .onDemandMaxPricePercentageOverLowestPrice(
                onDemandMaxPricePercentageOverLowestPrice?.applyValue({ args0 ->
                    args0
                }),
            )
            .requireHibernateSupport(requireHibernateSupport?.applyValue({ args0 -> args0 }))
            .spotMaxPricePercentageOverLowestPrice(
                spotMaxPricePercentageOverLowestPrice?.applyValue({ args0 ->
                    args0
                }),
            )
            .totalLocalStorageGb(
                totalLocalStorageGb?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .vcpuCount(vcpuCount?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsArgs].
 */
@PulumiTagMarker
public class SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsArgsBuilder internal constructor() {
    private var acceleratorCount:
        Output<SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsAcceleratorCountArgs>? =
        null

    private var acceleratorManufacturers: Output<List<String>>? = null

    private var acceleratorNames: Output<List<String>>? = null

    private var acceleratorTotalMemoryMib:
        Output<SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsAcceleratorTotalMemoryMibArgs>? =
        null

    private var acceleratorTypes: Output<List<String>>? = null

    private var allowedInstanceTypes: Output<List<String>>? = null

    private var bareMetal: Output<String>? = null

    private var baselineEbsBandwidthMbps:
        Output<SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsBaselineEbsBandwidthMbpsArgs>? =
        null

    private var burstablePerformance: Output<String>? = null

    private var cpuManufacturers: Output<List<String>>? = null

    private var excludedInstanceTypes: Output<List<String>>? = null

    private var instanceGenerations: Output<List<String>>? = null

    private var localStorage: Output<String>? = null

    private var localStorageTypes: Output<List<String>>? = null

    private var memoryGibPerVcpu:
        Output<SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsMemoryGibPerVcpuArgs>? =
        null

    private var memoryMib:
        Output<SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsMemoryMibArgs>? = null

    private var networkBandwidthGbps:
        Output<SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsNetworkBandwidthGbpsArgs>? =
        null

    private var networkInterfaceCount:
        Output<SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsNetworkInterfaceCountArgs>? =
        null

    private var onDemandMaxPricePercentageOverLowestPrice: Output<Int>? = null

    private var requireHibernateSupport: Output<Boolean>? = null

    private var spotMaxPricePercentageOverLowestPrice: Output<Int>? = null

    private var totalLocalStorageGb:
        Output<SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsTotalLocalStorageGbArgs>? =
        null

    private var vcpuCount:
        Output<SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsVcpuCountArgs>? = null

    /**
     * @param value Block describing the minimum and maximum number of accelerators (GPUs, FPGAs, or AWS Inferentia chips). Default is no minimum or maximum.
     */
    @JvmName("twftbuftopskxmkw")
    public suspend fun acceleratorCount(`value`: Output<SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsAcceleratorCountArgs>) {
        this.acceleratorCount = value
    }

    /**
     * @param value List of accelerator manufacturer names. Default is any manufacturer.
     * ```
     * Valid names:
     * * amazon-web-services
     * * amd
     * * nvidia
     * * xilinx
     * ```
     */
    @JvmName("hsgbxgpijdgomups")
    public suspend fun acceleratorManufacturers(`value`: Output<List<String>>) {
        this.acceleratorManufacturers = value
    }

    @JvmName("htqibyybxropmfec")
    public suspend fun acceleratorManufacturers(vararg values: Output<String>) {
        this.acceleratorManufacturers = Output.all(values.asList())
    }

    /**
     * @param values List of accelerator manufacturer names. Default is any manufacturer.
     * ```
     * Valid names:
     * * amazon-web-services
     * * amd
     * * nvidia
     * * xilinx
     * ```
     */
    @JvmName("ulmjhnmhljquyysi")
    public suspend fun acceleratorManufacturers(values: List<Output<String>>) {
        this.acceleratorManufacturers = Output.all(values)
    }

    /**
     * @param value List of accelerator names. Default is any acclerator.
     * ```
     * Valid names:
     * * a100            - NVIDIA A100 GPUs
     * * v100            - NVIDIA V100 GPUs
     * * k80             - NVIDIA K80 GPUs
     * * t4              - NVIDIA T4 GPUs
     * * m60             - NVIDIA M60 GPUs
     * * radeon-pro-v520 - AMD Radeon Pro V520 GPUs
     * * vu9p            - Xilinx VU9P FPGAs
     * ```
     */
    @JvmName("migrunbpywtwpnjt")
    public suspend fun acceleratorNames(`value`: Output<List<String>>) {
        this.acceleratorNames = value
    }

    @JvmName("eoskvevpixhuetmq")
    public suspend fun acceleratorNames(vararg values: Output<String>) {
        this.acceleratorNames = Output.all(values.asList())
    }

    /**
     * @param values List of accelerator names. Default is any acclerator.
     * ```
     * Valid names:
     * * a100            - NVIDIA A100 GPUs
     * * v100            - NVIDIA V100 GPUs
     * * k80             - NVIDIA K80 GPUs
     * * t4              - NVIDIA T4 GPUs
     * * m60             - NVIDIA M60 GPUs
     * * radeon-pro-v520 - AMD Radeon Pro V520 GPUs
     * * vu9p            - Xilinx VU9P FPGAs
     * ```
     */
    @JvmName("yduhsexoosmjyddd")
    public suspend fun acceleratorNames(values: List<Output<String>>) {
        this.acceleratorNames = Output.all(values)
    }

    /**
     * @param value Block describing the minimum and maximum total memory of the accelerators. Default is no minimum or maximum.
     */
    @JvmName("cdggmraippwrqfoi")
    public suspend fun acceleratorTotalMemoryMib(`value`: Output<SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsAcceleratorTotalMemoryMibArgs>) {
        this.acceleratorTotalMemoryMib = value
    }

    /**
     * @param value List of accelerator types. Default is any accelerator type.
     * ```
     * Valid types:
     * * fpga
     * * gpu
     * * inference
     * ```
     */
    @JvmName("cekxookiduemnahx")
    public suspend fun acceleratorTypes(`value`: Output<List<String>>) {
        this.acceleratorTypes = value
    }

    @JvmName("ebghwyatlidxfvyc")
    public suspend fun acceleratorTypes(vararg values: Output<String>) {
        this.acceleratorTypes = Output.all(values.asList())
    }

    /**
     * @param values List of accelerator types. Default is any accelerator type.
     * ```
     * Valid types:
     * * fpga
     * * gpu
     * * inference
     * ```
     */
    @JvmName("ynrtwbymemcempoq")
    public suspend fun acceleratorTypes(values: List<Output<String>>) {
        this.acceleratorTypes = Output.all(values)
    }

    /**
     * @param value List of instance types to apply your specified attributes against. All other instance types are ignored, even if they match your specified attributes. You can use strings with one or more wild cards, represented by an asterisk (\*), to allow an instance type, size, or generation. The following are examples: `m5.8xlarge`, `c5*.*`, `m5a.*`, `r*`, `*3*`. For example, if you specify `c5*`, you are allowing the entire C5 instance family, which includes all C5a and C5n instance types. If you specify `m5a.*`, you are allowing all the M5a instance types, but not the M5n instance types. Maximum of 400 entries in the list; each entry is limited to 30 characters. Default is all instance types.
     * > **NOTE:** If you specify `allowed_instance_types`, you can't specify `excluded_instance_types`.
     */
    @JvmName("vgwwycpakqqcpfia")
    public suspend fun allowedInstanceTypes(`value`: Output<List<String>>) {
        this.allowedInstanceTypes = value
    }

    @JvmName("enxifbmkvqeqkljt")
    public suspend fun allowedInstanceTypes(vararg values: Output<String>) {
        this.allowedInstanceTypes = Output.all(values.asList())
    }

    /**
     * @param values List of instance types to apply your specified attributes against. All other instance types are ignored, even if they match your specified attributes. You can use strings with one or more wild cards, represented by an asterisk (\*), to allow an instance type, size, or generation. The following are examples: `m5.8xlarge`, `c5*.*`, `m5a.*`, `r*`, `*3*`. For example, if you specify `c5*`, you are allowing the entire C5 instance family, which includes all C5a and C5n instance types. If you specify `m5a.*`, you are allowing all the M5a instance types, but not the M5n instance types. Maximum of 400 entries in the list; each entry is limited to 30 characters. Default is all instance types.
     * > **NOTE:** If you specify `allowed_instance_types`, you can't specify `excluded_instance_types`.
     */
    @JvmName("uuuuelkgojjuvpdd")
    public suspend fun allowedInstanceTypes(values: List<Output<String>>) {
        this.allowedInstanceTypes = Output.all(values)
    }

    /**
     * @param value Indicate whether bare metal instace types should be `included`, `excluded`, or `required`. Default is `excluded`.
     */
    @JvmName("rkgiprsryfcrckxy")
    public suspend fun bareMetal(`value`: Output<String>) {
        this.bareMetal = value
    }

    /**
     * @param value Block describing the minimum and maximum baseline EBS bandwidth, in Mbps. Default is no minimum or maximum.
     */
    @JvmName("orvywotursbuhlwh")
    public suspend fun baselineEbsBandwidthMbps(`value`: Output<SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsBaselineEbsBandwidthMbpsArgs>) {
        this.baselineEbsBandwidthMbps = value
    }

    /**
     * @param value Indicate whether burstable performance instance types should be `included`, `excluded`, or `required`. Default is `excluded`.
     */
    @JvmName("kficidwbhbvvicnt")
    public suspend fun burstablePerformance(`value`: Output<String>) {
        this.burstablePerformance = value
    }

    /**
     * @param value List of CPU manufacturer names. Default is any manufacturer.
     * > **NOTE:** Don't confuse the CPU hardware manufacturer with the CPU hardware architecture. Instances will be launched with a compatible CPU architecture based on the Amazon Machine Image (AMI) that you specify in your launch template.
     * ```
     * Valid names:
     * * amazon-web-services
     * * amd
     * * intel
     * ```
     */
    @JvmName("dnfcqiedilcbxnqh")
    public suspend fun cpuManufacturers(`value`: Output<List<String>>) {
        this.cpuManufacturers = value
    }

    @JvmName("varnnebqtaponqrf")
    public suspend fun cpuManufacturers(vararg values: Output<String>) {
        this.cpuManufacturers = Output.all(values.asList())
    }

    /**
     * @param values List of CPU manufacturer names. Default is any manufacturer.
     * > **NOTE:** Don't confuse the CPU hardware manufacturer with the CPU hardware architecture. Instances will be launched with a compatible CPU architecture based on the Amazon Machine Image (AMI) that you specify in your launch template.
     * ```
     * Valid names:
     * * amazon-web-services
     * * amd
     * * intel
     * ```
     */
    @JvmName("sbulfgkidgemutif")
    public suspend fun cpuManufacturers(values: List<Output<String>>) {
        this.cpuManufacturers = Output.all(values)
    }

    /**
     * @param value List of instance types to exclude. You can use strings with one or more wild cards, represented by an asterisk (\*), to exclude an instance type, size, or generation. The following are examples: `m5.8xlarge`, `c5*.*`, `m5a.*`, `r*`, `*3*`. For example, if you specify `c5*`, you are excluding the entire C5 instance family, which includes all C5a and C5n instance types. If you specify `m5a.*`, you are excluding all the M5a instance types, but not the M5n instance types. Maximum of 400 entries in the list; each entry is limited to 30 characters. Default is no excluded instance types.
     * > **NOTE:** If you specify `excluded_instance_types`, you can't specify `allowed_instance_types`.
     */
    @JvmName("wdvsrnooawaorsfm")
    public suspend fun excludedInstanceTypes(`value`: Output<List<String>>) {
        this.excludedInstanceTypes = value
    }

    @JvmName("bteoxxixsbxloaru")
    public suspend fun excludedInstanceTypes(vararg values: Output<String>) {
        this.excludedInstanceTypes = Output.all(values.asList())
    }

    /**
     * @param values List of instance types to exclude. You can use strings with one or more wild cards, represented by an asterisk (\*), to exclude an instance type, size, or generation. The following are examples: `m5.8xlarge`, `c5*.*`, `m5a.*`, `r*`, `*3*`. For example, if you specify `c5*`, you are excluding the entire C5 instance family, which includes all C5a and C5n instance types. If you specify `m5a.*`, you are excluding all the M5a instance types, but not the M5n instance types. Maximum of 400 entries in the list; each entry is limited to 30 characters. Default is no excluded instance types.
     * > **NOTE:** If you specify `excluded_instance_types`, you can't specify `allowed_instance_types`.
     */
    @JvmName("tggximagqvnbuqea")
    public suspend fun excludedInstanceTypes(values: List<Output<String>>) {
        this.excludedInstanceTypes = Output.all(values)
    }

    /**
     * @param value List of instance generation names. Default is any generation.
     * ```
     * Valid names:
     * * current  - Recommended for best performance.
     * * previous - For existing applications optimized for older instance types.
     * ```
     */
    @JvmName("avsfioklscbfqxac")
    public suspend fun instanceGenerations(`value`: Output<List<String>>) {
        this.instanceGenerations = value
    }

    @JvmName("hnqfiouqppuwnpfu")
    public suspend fun instanceGenerations(vararg values: Output<String>) {
        this.instanceGenerations = Output.all(values.asList())
    }

    /**
     * @param values List of instance generation names. Default is any generation.
     * ```
     * Valid names:
     * * current  - Recommended for best performance.
     * * previous - For existing applications optimized for older instance types.
     * ```
     */
    @JvmName("bcbqbmukxogmpgnw")
    public suspend fun instanceGenerations(values: List<Output<String>>) {
        this.instanceGenerations = Output.all(values)
    }

    /**
     * @param value Indicate whether instance types with local storage volumes are `included`, `excluded`, or `required`. Default is `included`.
     */
    @JvmName("tprhqwuvqojwtrqo")
    public suspend fun localStorage(`value`: Output<String>) {
        this.localStorage = value
    }

    /**
     * @param value List of local storage type names. Default any storage type.
     * ```
     * Value names:
     * * hdd - hard disk drive
     * * ssd - solid state drive
     * ```
     */
    @JvmName("qmnhahutqjmnkbqj")
    public suspend fun localStorageTypes(`value`: Output<List<String>>) {
        this.localStorageTypes = value
    }

    @JvmName("fqifaqmntimuekau")
    public suspend fun localStorageTypes(vararg values: Output<String>) {
        this.localStorageTypes = Output.all(values.asList())
    }

    /**
     * @param values List of local storage type names. Default any storage type.
     * ```
     * Value names:
     * * hdd - hard disk drive
     * * ssd - solid state drive
     * ```
     */
    @JvmName("vysmpvujhrmjxbbj")
    public suspend fun localStorageTypes(values: List<Output<String>>) {
        this.localStorageTypes = Output.all(values)
    }

    /**
     * @param value Block describing the minimum and maximum amount of memory (GiB) per vCPU. Default is no minimum or maximum.
     */
    @JvmName("mswxdyfwtqjlcxsk")
    public suspend fun memoryGibPerVcpu(`value`: Output<SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsMemoryGibPerVcpuArgs>) {
        this.memoryGibPerVcpu = value
    }

    /**
     * @param value Block describing the minimum and maximum amount of memory (MiB). Default is no maximum.
     */
    @JvmName("lliocifqkcdxovai")
    public suspend fun memoryMib(`value`: Output<SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsMemoryMibArgs>) {
        this.memoryMib = value
    }

    /**
     * @param value Block describing the minimum and maximum amount of network bandwidth, in gigabits per second (Gbps). Default is no minimum or maximum.
     */
    @JvmName("mucsutcgtqrkqude")
    public suspend fun networkBandwidthGbps(`value`: Output<SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsNetworkBandwidthGbpsArgs>) {
        this.networkBandwidthGbps = value
    }

    /**
     * @param value Block describing the minimum and maximum number of network interfaces. Default is no minimum or maximum.
     */
    @JvmName("niiuyrxfojsxuevy")
    public suspend fun networkInterfaceCount(`value`: Output<SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsNetworkInterfaceCountArgs>) {
        this.networkInterfaceCount = value
    }

    /**
     * @param value The price protection threshold for On-Demand Instances. This is the maximum you’ll pay for an On-Demand Instance, expressed as a percentage higher than the cheapest M, C, or R instance type with your specified attributes. When Amazon EC2 Auto Scaling selects instance types with your attributes, we will exclude instance types whose price is higher than your threshold. The parameter accepts an integer, which Amazon EC2 Auto Scaling interprets as a percentage. To turn off price protection, specify a high value, such as 999999. Default is 20.
     * If you set DesiredCapacityType to vcpu or memory-mib, the price protection threshold is applied based on the per vCPU or per memory price instead of the per instance price.
     */
    @JvmName("xxnflrddsvnbbleu")
    public suspend fun onDemandMaxPricePercentageOverLowestPrice(`value`: Output<Int>) {
        this.onDemandMaxPricePercentageOverLowestPrice = value
    }

    /**
     * @param value Indicate whether instance types must support On-Demand Instance Hibernation, either `true` or `false`. Default is `false`.
     */
    @JvmName("suoabfonxegsdkkg")
    public suspend fun requireHibernateSupport(`value`: Output<Boolean>) {
        this.requireHibernateSupport = value
    }

    /**
     * @param value The price protection threshold for Spot Instances. This is the maximum you’ll pay for a Spot Instance, expressed as a percentage higher than the cheapest M, C, or R instance type with your specified attributes. When Amazon EC2 Auto Scaling selects instance types with your attributes, we will exclude instance types whose price is higher than your threshold. The parameter accepts an integer, which Amazon EC2 Auto Scaling interprets as a percentage. To turn off price protection, specify a high value, such as 999999. Default is 100.
     * If you set DesiredCapacityType to vcpu or memory-mib, the price protection threshold is applied based on the per vCPU or per memory price instead of the per instance price.
     */
    @JvmName("dwxajcmjtpcwssgb")
    public suspend fun spotMaxPricePercentageOverLowestPrice(`value`: Output<Int>) {
        this.spotMaxPricePercentageOverLowestPrice = value
    }

    /**
     * @param value Block describing the minimum and maximum total local storage (GB). Default is no minimum or maximum.
     */
    @JvmName("yxktydkcmuhpdrcf")
    public suspend fun totalLocalStorageGb(`value`: Output<SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsTotalLocalStorageGbArgs>) {
        this.totalLocalStorageGb = value
    }

    /**
     * @param value Block describing the minimum and maximum number of vCPUs. Default is no maximum.
     */
    @JvmName("vwywqobwgemmrqob")
    public suspend fun vcpuCount(`value`: Output<SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsVcpuCountArgs>) {
        this.vcpuCount = value
    }

    /**
     * @param value Block describing the minimum and maximum number of accelerators (GPUs, FPGAs, or AWS Inferentia chips). Default is no minimum or maximum.
     */
    @JvmName("hcpmtgoekcpcxfkv")
    public suspend fun acceleratorCount(`value`: SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsAcceleratorCountArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acceleratorCount = mapped
    }

    /**
     * @param argument Block describing the minimum and maximum number of accelerators (GPUs, FPGAs, or AWS Inferentia chips). Default is no minimum or maximum.
     */
    @JvmName("xwbtbhpgwotjjnia")
    public suspend fun acceleratorCount(argument: suspend SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsAcceleratorCountArgsBuilder.() -> Unit) {
        val toBeMapped =
            SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsAcceleratorCountArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.acceleratorCount = mapped
    }

    /**
     * @param value List of accelerator manufacturer names. Default is any manufacturer.
     * ```
     * Valid names:
     * * amazon-web-services
     * * amd
     * * nvidia
     * * xilinx
     * ```
     */
    @JvmName("xhdhmklevokeaggx")
    public suspend fun acceleratorManufacturers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acceleratorManufacturers = mapped
    }

    /**
     * @param values List of accelerator manufacturer names. Default is any manufacturer.
     * ```
     * Valid names:
     * * amazon-web-services
     * * amd
     * * nvidia
     * * xilinx
     * ```
     */
    @JvmName("cnxjwkgdqxijpwgi")
    public suspend fun acceleratorManufacturers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.acceleratorManufacturers = mapped
    }

    /**
     * @param value List of accelerator names. Default is any acclerator.
     * ```
     * Valid names:
     * * a100            - NVIDIA A100 GPUs
     * * v100            - NVIDIA V100 GPUs
     * * k80             - NVIDIA K80 GPUs
     * * t4              - NVIDIA T4 GPUs
     * * m60             - NVIDIA M60 GPUs
     * * radeon-pro-v520 - AMD Radeon Pro V520 GPUs
     * * vu9p            - Xilinx VU9P FPGAs
     * ```
     */
    @JvmName("nkcatbyjwwffxkpt")
    public suspend fun acceleratorNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acceleratorNames = mapped
    }

    /**
     * @param values List of accelerator names. Default is any acclerator.
     * ```
     * Valid names:
     * * a100            - NVIDIA A100 GPUs
     * * v100            - NVIDIA V100 GPUs
     * * k80             - NVIDIA K80 GPUs
     * * t4              - NVIDIA T4 GPUs
     * * m60             - NVIDIA M60 GPUs
     * * radeon-pro-v520 - AMD Radeon Pro V520 GPUs
     * * vu9p            - Xilinx VU9P FPGAs
     * ```
     */
    @JvmName("gbokvhahyugoxkik")
    public suspend fun acceleratorNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.acceleratorNames = mapped
    }

    /**
     * @param value Block describing the minimum and maximum total memory of the accelerators. Default is no minimum or maximum.
     */
    @JvmName("subfrqtoyfbvrgln")
    public suspend fun acceleratorTotalMemoryMib(`value`: SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsAcceleratorTotalMemoryMibArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acceleratorTotalMemoryMib = mapped
    }

    /**
     * @param argument Block describing the minimum and maximum total memory of the accelerators. Default is no minimum or maximum.
     */
    @JvmName("ivyetuskdgwvujjq")
    public suspend fun acceleratorTotalMemoryMib(argument: suspend SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsAcceleratorTotalMemoryMibArgsBuilder.() -> Unit) {
        val toBeMapped =
            SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsAcceleratorTotalMemoryMibArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.acceleratorTotalMemoryMib = mapped
    }

    /**
     * @param value List of accelerator types. Default is any accelerator type.
     * ```
     * Valid types:
     * * fpga
     * * gpu
     * * inference
     * ```
     */
    @JvmName("pmonmrtafhxvlpmr")
    public suspend fun acceleratorTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acceleratorTypes = mapped
    }

    /**
     * @param values List of accelerator types. Default is any accelerator type.
     * ```
     * Valid types:
     * * fpga
     * * gpu
     * * inference
     * ```
     */
    @JvmName("scelcnccobpqinfm")
    public suspend fun acceleratorTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.acceleratorTypes = mapped
    }

    /**
     * @param value List of instance types to apply your specified attributes against. All other instance types are ignored, even if they match your specified attributes. You can use strings with one or more wild cards, represented by an asterisk (\*), to allow an instance type, size, or generation. The following are examples: `m5.8xlarge`, `c5*.*`, `m5a.*`, `r*`, `*3*`. For example, if you specify `c5*`, you are allowing the entire C5 instance family, which includes all C5a and C5n instance types. If you specify `m5a.*`, you are allowing all the M5a instance types, but not the M5n instance types. Maximum of 400 entries in the list; each entry is limited to 30 characters. Default is all instance types.
     * > **NOTE:** If you specify `allowed_instance_types`, you can't specify `excluded_instance_types`.
     */
    @JvmName("vfeqgluknqyecfjc")
    public suspend fun allowedInstanceTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedInstanceTypes = mapped
    }

    /**
     * @param values List of instance types to apply your specified attributes against. All other instance types are ignored, even if they match your specified attributes. You can use strings with one or more wild cards, represented by an asterisk (\*), to allow an instance type, size, or generation. The following are examples: `m5.8xlarge`, `c5*.*`, `m5a.*`, `r*`, `*3*`. For example, if you specify `c5*`, you are allowing the entire C5 instance family, which includes all C5a and C5n instance types. If you specify `m5a.*`, you are allowing all the M5a instance types, but not the M5n instance types. Maximum of 400 entries in the list; each entry is limited to 30 characters. Default is all instance types.
     * > **NOTE:** If you specify `allowed_instance_types`, you can't specify `excluded_instance_types`.
     */
    @JvmName("farfctwjwcveebmx")
    public suspend fun allowedInstanceTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedInstanceTypes = mapped
    }

    /**
     * @param value Indicate whether bare metal instace types should be `included`, `excluded`, or `required`. Default is `excluded`.
     */
    @JvmName("binysvalelonbkks")
    public suspend fun bareMetal(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bareMetal = mapped
    }

    /**
     * @param value Block describing the minimum and maximum baseline EBS bandwidth, in Mbps. Default is no minimum or maximum.
     */
    @JvmName("kfxfaplgcqcoioux")
    public suspend fun baselineEbsBandwidthMbps(`value`: SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsBaselineEbsBandwidthMbpsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.baselineEbsBandwidthMbps = mapped
    }

    /**
     * @param argument Block describing the minimum and maximum baseline EBS bandwidth, in Mbps. Default is no minimum or maximum.
     */
    @JvmName("iavymbmkfpavkowi")
    public suspend fun baselineEbsBandwidthMbps(argument: suspend SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsBaselineEbsBandwidthMbpsArgsBuilder.() -> Unit) {
        val toBeMapped =
            SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsBaselineEbsBandwidthMbpsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.baselineEbsBandwidthMbps = mapped
    }

    /**
     * @param value Indicate whether burstable performance instance types should be `included`, `excluded`, or `required`. Default is `excluded`.
     */
    @JvmName("leneiisyahjeviyl")
    public suspend fun burstablePerformance(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.burstablePerformance = mapped
    }

    /**
     * @param value List of CPU manufacturer names. Default is any manufacturer.
     * > **NOTE:** Don't confuse the CPU hardware manufacturer with the CPU hardware architecture. Instances will be launched with a compatible CPU architecture based on the Amazon Machine Image (AMI) that you specify in your launch template.
     * ```
     * Valid names:
     * * amazon-web-services
     * * amd
     * * intel
     * ```
     */
    @JvmName("wyorguisxmhhnhgd")
    public suspend fun cpuManufacturers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cpuManufacturers = mapped
    }

    /**
     * @param values List of CPU manufacturer names. Default is any manufacturer.
     * > **NOTE:** Don't confuse the CPU hardware manufacturer with the CPU hardware architecture. Instances will be launched with a compatible CPU architecture based on the Amazon Machine Image (AMI) that you specify in your launch template.
     * ```
     * Valid names:
     * * amazon-web-services
     * * amd
     * * intel
     * ```
     */
    @JvmName("urgmogjlqytsbybu")
    public suspend fun cpuManufacturers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cpuManufacturers = mapped
    }

    /**
     * @param value List of instance types to exclude. You can use strings with one or more wild cards, represented by an asterisk (\*), to exclude an instance type, size, or generation. The following are examples: `m5.8xlarge`, `c5*.*`, `m5a.*`, `r*`, `*3*`. For example, if you specify `c5*`, you are excluding the entire C5 instance family, which includes all C5a and C5n instance types. If you specify `m5a.*`, you are excluding all the M5a instance types, but not the M5n instance types. Maximum of 400 entries in the list; each entry is limited to 30 characters. Default is no excluded instance types.
     * > **NOTE:** If you specify `excluded_instance_types`, you can't specify `allowed_instance_types`.
     */
    @JvmName("qjfwxaoigpmmjvis")
    public suspend fun excludedInstanceTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.excludedInstanceTypes = mapped
    }

    /**
     * @param values List of instance types to exclude. You can use strings with one or more wild cards, represented by an asterisk (\*), to exclude an instance type, size, or generation. The following are examples: `m5.8xlarge`, `c5*.*`, `m5a.*`, `r*`, `*3*`. For example, if you specify `c5*`, you are excluding the entire C5 instance family, which includes all C5a and C5n instance types. If you specify `m5a.*`, you are excluding all the M5a instance types, but not the M5n instance types. Maximum of 400 entries in the list; each entry is limited to 30 characters. Default is no excluded instance types.
     * > **NOTE:** If you specify `excluded_instance_types`, you can't specify `allowed_instance_types`.
     */
    @JvmName("lcsrpbmdmdeygiqt")
    public suspend fun excludedInstanceTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.excludedInstanceTypes = mapped
    }

    /**
     * @param value List of instance generation names. Default is any generation.
     * ```
     * Valid names:
     * * current  - Recommended for best performance.
     * * previous - For existing applications optimized for older instance types.
     * ```
     */
    @JvmName("wavxusblyjgyvblv")
    public suspend fun instanceGenerations(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceGenerations = mapped
    }

    /**
     * @param values List of instance generation names. Default is any generation.
     * ```
     * Valid names:
     * * current  - Recommended for best performance.
     * * previous - For existing applications optimized for older instance types.
     * ```
     */
    @JvmName("qdutogsdkahnxwqs")
    public suspend fun instanceGenerations(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceGenerations = mapped
    }

    /**
     * @param value Indicate whether instance types with local storage volumes are `included`, `excluded`, or `required`. Default is `included`.
     */
    @JvmName("vbuijidepnlifwgd")
    public suspend fun localStorage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localStorage = mapped
    }

    /**
     * @param value List of local storage type names. Default any storage type.
     * ```
     * Value names:
     * * hdd - hard disk drive
     * * ssd - solid state drive
     * ```
     */
    @JvmName("gbsspgqnopwcttqd")
    public suspend fun localStorageTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localStorageTypes = mapped
    }

    /**
     * @param values List of local storage type names. Default any storage type.
     * ```
     * Value names:
     * * hdd - hard disk drive
     * * ssd - solid state drive
     * ```
     */
    @JvmName("pvfrgeofjtjcogwi")
    public suspend fun localStorageTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.localStorageTypes = mapped
    }

    /**
     * @param value Block describing the minimum and maximum amount of memory (GiB) per vCPU. Default is no minimum or maximum.
     */
    @JvmName("iugbwumhomncmyem")
    public suspend fun memoryGibPerVcpu(`value`: SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsMemoryGibPerVcpuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memoryGibPerVcpu = mapped
    }

    /**
     * @param argument Block describing the minimum and maximum amount of memory (GiB) per vCPU. Default is no minimum or maximum.
     */
    @JvmName("qyihlendxsboitll")
    public suspend fun memoryGibPerVcpu(argument: suspend SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsMemoryGibPerVcpuArgsBuilder.() -> Unit) {
        val toBeMapped =
            SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsMemoryGibPerVcpuArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.memoryGibPerVcpu = mapped
    }

    /**
     * @param value Block describing the minimum and maximum amount of memory (MiB). Default is no maximum.
     */
    @JvmName("oqpnbbpybykymybw")
    public suspend fun memoryMib(`value`: SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsMemoryMibArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memoryMib = mapped
    }

    /**
     * @param argument Block describing the minimum and maximum amount of memory (MiB). Default is no maximum.
     */
    @JvmName("wijpnfidevdvgqpc")
    public suspend fun memoryMib(argument: suspend SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsMemoryMibArgsBuilder.() -> Unit) {
        val toBeMapped =
            SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsMemoryMibArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.memoryMib = mapped
    }

    /**
     * @param value Block describing the minimum and maximum amount of network bandwidth, in gigabits per second (Gbps). Default is no minimum or maximum.
     */
    @JvmName("qthkjqwfwvamowwk")
    public suspend fun networkBandwidthGbps(`value`: SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsNetworkBandwidthGbpsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkBandwidthGbps = mapped
    }

    /**
     * @param argument Block describing the minimum and maximum amount of network bandwidth, in gigabits per second (Gbps). Default is no minimum or maximum.
     */
    @JvmName("wacqlsjujbfwpraf")
    public suspend fun networkBandwidthGbps(argument: suspend SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsNetworkBandwidthGbpsArgsBuilder.() -> Unit) {
        val toBeMapped =
            SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsNetworkBandwidthGbpsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.networkBandwidthGbps = mapped
    }

    /**
     * @param value Block describing the minimum and maximum number of network interfaces. Default is no minimum or maximum.
     */
    @JvmName("lcfpbrbhesxelrwo")
    public suspend fun networkInterfaceCount(`value`: SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsNetworkInterfaceCountArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInterfaceCount = mapped
    }

    /**
     * @param argument Block describing the minimum and maximum number of network interfaces. Default is no minimum or maximum.
     */
    @JvmName("nyyegqofggnixfop")
    public suspend fun networkInterfaceCount(argument: suspend SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsNetworkInterfaceCountArgsBuilder.() -> Unit) {
        val toBeMapped =
            SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsNetworkInterfaceCountArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.networkInterfaceCount = mapped
    }

    /**
     * @param value The price protection threshold for On-Demand Instances. This is the maximum you’ll pay for an On-Demand Instance, expressed as a percentage higher than the cheapest M, C, or R instance type with your specified attributes. When Amazon EC2 Auto Scaling selects instance types with your attributes, we will exclude instance types whose price is higher than your threshold. The parameter accepts an integer, which Amazon EC2 Auto Scaling interprets as a percentage. To turn off price protection, specify a high value, such as 999999. Default is 20.
     * If you set DesiredCapacityType to vcpu or memory-mib, the price protection threshold is applied based on the per vCPU or per memory price instead of the per instance price.
     */
    @JvmName("wkoinxnscixhiwtx")
    public suspend fun onDemandMaxPricePercentageOverLowestPrice(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onDemandMaxPricePercentageOverLowestPrice = mapped
    }

    /**
     * @param value Indicate whether instance types must support On-Demand Instance Hibernation, either `true` or `false`. Default is `false`.
     */
    @JvmName("dttrmrroouaxycjt")
    public suspend fun requireHibernateSupport(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requireHibernateSupport = mapped
    }

    /**
     * @param value The price protection threshold for Spot Instances. This is the maximum you’ll pay for a Spot Instance, expressed as a percentage higher than the cheapest M, C, or R instance type with your specified attributes. When Amazon EC2 Auto Scaling selects instance types with your attributes, we will exclude instance types whose price is higher than your threshold. The parameter accepts an integer, which Amazon EC2 Auto Scaling interprets as a percentage. To turn off price protection, specify a high value, such as 999999. Default is 100.
     * If you set DesiredCapacityType to vcpu or memory-mib, the price protection threshold is applied based on the per vCPU or per memory price instead of the per instance price.
     */
    @JvmName("nayhyxkgpditqaqc")
    public suspend fun spotMaxPricePercentageOverLowestPrice(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spotMaxPricePercentageOverLowestPrice = mapped
    }

    /**
     * @param value Block describing the minimum and maximum total local storage (GB). Default is no minimum or maximum.
     */
    @JvmName("aosgosnhueulbnbu")
    public suspend fun totalLocalStorageGb(`value`: SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsTotalLocalStorageGbArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.totalLocalStorageGb = mapped
    }

    /**
     * @param argument Block describing the minimum and maximum total local storage (GB). Default is no minimum or maximum.
     */
    @JvmName("bfkniwpwfgonltbg")
    public suspend fun totalLocalStorageGb(argument: suspend SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsTotalLocalStorageGbArgsBuilder.() -> Unit) {
        val toBeMapped =
            SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsTotalLocalStorageGbArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.totalLocalStorageGb = mapped
    }

    /**
     * @param value Block describing the minimum and maximum number of vCPUs. Default is no maximum.
     */
    @JvmName("fqsnrmvryebcwegd")
    public suspend fun vcpuCount(`value`: SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsVcpuCountArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vcpuCount = mapped
    }

    /**
     * @param argument Block describing the minimum and maximum number of vCPUs. Default is no maximum.
     */
    @JvmName("ngujjnremqixwdiq")
    public suspend fun vcpuCount(argument: suspend SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsVcpuCountArgsBuilder.() -> Unit) {
        val toBeMapped =
            SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsVcpuCountArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.vcpuCount = mapped
    }

    internal fun build(): SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsArgs =
        SpotFleetRequestLaunchTemplateConfigOverrideInstanceRequirementsArgs(
            acceleratorCount = acceleratorCount,
            acceleratorManufacturers = acceleratorManufacturers,
            acceleratorNames = acceleratorNames,
            acceleratorTotalMemoryMib = acceleratorTotalMemoryMib,
            acceleratorTypes = acceleratorTypes,
            allowedInstanceTypes = allowedInstanceTypes,
            bareMetal = bareMetal,
            baselineEbsBandwidthMbps = baselineEbsBandwidthMbps,
            burstablePerformance = burstablePerformance,
            cpuManufacturers = cpuManufacturers,
            excludedInstanceTypes = excludedInstanceTypes,
            instanceGenerations = instanceGenerations,
            localStorage = localStorage,
            localStorageTypes = localStorageTypes,
            memoryGibPerVcpu = memoryGibPerVcpu,
            memoryMib = memoryMib,
            networkBandwidthGbps = networkBandwidthGbps,
            networkInterfaceCount = networkInterfaceCount,
            onDemandMaxPricePercentageOverLowestPrice = onDemandMaxPricePercentageOverLowestPrice,
            requireHibernateSupport = requireHibernateSupport,
            spotMaxPricePercentageOverLowestPrice = spotMaxPricePercentageOverLowestPrice,
            totalLocalStorageGb = totalLocalStorageGb,
            vcpuCount = vcpuCount,
        )
}
