@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.SpotFleetRequestSpotMaintenanceStrategiesCapacityRebalanceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property replacementStrategy The replacement strategy to use. Only available for spot fleets with `fleet_type` set to `maintain`. Valid values: `launch`.
 */
public data class SpotFleetRequestSpotMaintenanceStrategiesCapacityRebalanceArgs(
    public val replacementStrategy: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.ec2.inputs.SpotFleetRequestSpotMaintenanceStrategiesCapacityRebalanceArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.SpotFleetRequestSpotMaintenanceStrategiesCapacityRebalanceArgs =
        com.pulumi.aws.ec2.inputs.SpotFleetRequestSpotMaintenanceStrategiesCapacityRebalanceArgs.builder()
            .replacementStrategy(replacementStrategy?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SpotFleetRequestSpotMaintenanceStrategiesCapacityRebalanceArgs].
 */
@PulumiTagMarker
public class SpotFleetRequestSpotMaintenanceStrategiesCapacityRebalanceArgsBuilder internal constructor() {
    private var replacementStrategy: Output<String>? = null

    /**
     * @param value The replacement strategy to use. Only available for spot fleets with `fleet_type` set to `maintain`. Valid values: `launch`.
     */
    @JvmName("ifncnlfyjkpcxhbv")
    public suspend fun replacementStrategy(`value`: Output<String>) {
        this.replacementStrategy = value
    }

    /**
     * @param value The replacement strategy to use. Only available for spot fleets with `fleet_type` set to `maintain`. Valid values: `launch`.
     */
    @JvmName("lbkryakcieivxxfn")
    public suspend fun replacementStrategy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replacementStrategy = mapped
    }

    internal fun build(): SpotFleetRequestSpotMaintenanceStrategiesCapacityRebalanceArgs =
        SpotFleetRequestSpotMaintenanceStrategiesCapacityRebalanceArgs(
            replacementStrategy = replacementStrategy,
        )
}
