@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.SpotInstanceRequestCapacityReservationSpecificationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property capacityReservationPreference Indicates the instance's Capacity Reservation preferences. Can be `"open"` or `"none"`. (Default: `"open"`).
 * @property capacityReservationTarget Information about the target Capacity Reservation. See Capacity Reservation Target below for more details.
 * For more information, see the documentation on [Capacity Reservations](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/capacity-reservations-using.html).
 */
public data class SpotInstanceRequestCapacityReservationSpecificationArgs(
    public val capacityReservationPreference: Output<String>? = null,
    public val capacityReservationTarget: Output<SpotInstanceRequestCapacityReservationSpecificationCapacityReservationTargetArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.ec2.inputs.SpotInstanceRequestCapacityReservationSpecificationArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.SpotInstanceRequestCapacityReservationSpecificationArgs =
        com.pulumi.aws.ec2.inputs.SpotInstanceRequestCapacityReservationSpecificationArgs.builder()
            .capacityReservationPreference(capacityReservationPreference?.applyValue({ args0 -> args0 }))
            .capacityReservationTarget(
                capacityReservationTarget?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [SpotInstanceRequestCapacityReservationSpecificationArgs].
 */
@PulumiTagMarker
public class SpotInstanceRequestCapacityReservationSpecificationArgsBuilder internal constructor() {
    private var capacityReservationPreference: Output<String>? = null

    private var capacityReservationTarget:
        Output<SpotInstanceRequestCapacityReservationSpecificationCapacityReservationTargetArgs>? =
        null

    /**
     * @param value Indicates the instance's Capacity Reservation preferences. Can be `"open"` or `"none"`. (Default: `"open"`).
     */
    @JvmName("eawxxbmndivlggql")
    public suspend fun capacityReservationPreference(`value`: Output<String>) {
        this.capacityReservationPreference = value
    }

    /**
     * @param value Information about the target Capacity Reservation. See Capacity Reservation Target below for more details.
     * For more information, see the documentation on [Capacity Reservations](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/capacity-reservations-using.html).
     */
    @JvmName("nxqbdtygvtfjdlth")
    public suspend fun capacityReservationTarget(`value`: Output<SpotInstanceRequestCapacityReservationSpecificationCapacityReservationTargetArgs>) {
        this.capacityReservationTarget = value
    }

    /**
     * @param value Indicates the instance's Capacity Reservation preferences. Can be `"open"` or `"none"`. (Default: `"open"`).
     */
    @JvmName("xeqxjvlhuhotkmto")
    public suspend fun capacityReservationPreference(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacityReservationPreference = mapped
    }

    /**
     * @param value Information about the target Capacity Reservation. See Capacity Reservation Target below for more details.
     * For more information, see the documentation on [Capacity Reservations](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/capacity-reservations-using.html).
     */
    @JvmName("ogqmavfmhuqrkykh")
    public suspend fun capacityReservationTarget(`value`: SpotInstanceRequestCapacityReservationSpecificationCapacityReservationTargetArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacityReservationTarget = mapped
    }

    /**
     * @param argument Information about the target Capacity Reservation. See Capacity Reservation Target below for more details.
     * For more information, see the documentation on [Capacity Reservations](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/capacity-reservations-using.html).
     */
    @JvmName("mkbjednjncsecpsr")
    public suspend fun capacityReservationTarget(argument: suspend SpotInstanceRequestCapacityReservationSpecificationCapacityReservationTargetArgsBuilder.() -> Unit) {
        val toBeMapped =
            SpotInstanceRequestCapacityReservationSpecificationCapacityReservationTargetArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.capacityReservationTarget = mapped
    }

    internal fun build(): SpotInstanceRequestCapacityReservationSpecificationArgs =
        SpotInstanceRequestCapacityReservationSpecificationArgs(
            capacityReservationPreference = capacityReservationPreference,
            capacityReservationTarget = capacityReservationTarget,
        )
}
