@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.SpotInstanceRequestCapacityReservationSpecificationCapacityReservationTargetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property capacityReservationId ID of the Capacity Reservation in which to run the instance.
 * @property capacityReservationResourceGroupArn ARN of the Capacity Reservation resource group in which to run the instance.
 */
public data class SpotInstanceRequestCapacityReservationSpecificationCapacityReservationTargetArgs(
    public val capacityReservationId: Output<String>? = null,
    public val capacityReservationResourceGroupArn: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.ec2.inputs.SpotInstanceRequestCapacityReservationSpecificationCapacityReservationTargetArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.SpotInstanceRequestCapacityReservationSpecificationCapacityReservationTargetArgs =
        com.pulumi.aws.ec2.inputs.SpotInstanceRequestCapacityReservationSpecificationCapacityReservationTargetArgs.builder()
            .capacityReservationId(capacityReservationId?.applyValue({ args0 -> args0 }))
            .capacityReservationResourceGroupArn(
                capacityReservationResourceGroupArn?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [SpotInstanceRequestCapacityReservationSpecificationCapacityReservationTargetArgs].
 */
@PulumiTagMarker
public class SpotInstanceRequestCapacityReservationSpecificationCapacityReservationTargetArgsBuilder
internal constructor() {
    private var capacityReservationId: Output<String>? = null

    private var capacityReservationResourceGroupArn: Output<String>? = null

    /**
     * @param value ID of the Capacity Reservation in which to run the instance.
     */
    @JvmName("ceewhjgaxjitjfhl")
    public suspend fun capacityReservationId(`value`: Output<String>) {
        this.capacityReservationId = value
    }

    /**
     * @param value ARN of the Capacity Reservation resource group in which to run the instance.
     */
    @JvmName("ureictqcwwgxltxl")
    public suspend fun capacityReservationResourceGroupArn(`value`: Output<String>) {
        this.capacityReservationResourceGroupArn = value
    }

    /**
     * @param value ID of the Capacity Reservation in which to run the instance.
     */
    @JvmName("sojhrtrjhnvijbhw")
    public suspend fun capacityReservationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacityReservationId = mapped
    }

    /**
     * @param value ARN of the Capacity Reservation resource group in which to run the instance.
     */
    @JvmName("jsbjaesacgutovwm")
    public suspend fun capacityReservationResourceGroupArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacityReservationResourceGroupArn = mapped
    }

    internal fun build(): SpotInstanceRequestCapacityReservationSpecificationCapacityReservationTargetArgs =
        SpotInstanceRequestCapacityReservationSpecificationCapacityReservationTargetArgs(
            capacityReservationId = capacityReservationId,
            capacityReservationResourceGroupArn = capacityReservationResourceGroupArn,
        )
}
