@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.SpotInstanceRequestMaintenanceOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property autoRecovery Automatic recovery behavior of the Instance. Can be `"default"` or `"disabled"`. See [Recover your instance](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-recover.html) for more details.
 */
public data class SpotInstanceRequestMaintenanceOptionsArgs(
    public val autoRecovery: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.SpotInstanceRequestMaintenanceOptionsArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.SpotInstanceRequestMaintenanceOptionsArgs =
        com.pulumi.aws.ec2.inputs.SpotInstanceRequestMaintenanceOptionsArgs.builder()
            .autoRecovery(autoRecovery?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SpotInstanceRequestMaintenanceOptionsArgs].
 */
@PulumiTagMarker
public class SpotInstanceRequestMaintenanceOptionsArgsBuilder internal constructor() {
    private var autoRecovery: Output<String>? = null

    /**
     * @param value Automatic recovery behavior of the Instance. Can be `"default"` or `"disabled"`. See [Recover your instance](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-recover.html) for more details.
     */
    @JvmName("abiawrwbtokhwblb")
    public suspend fun autoRecovery(`value`: Output<String>) {
        this.autoRecovery = value
    }

    /**
     * @param value Automatic recovery behavior of the Instance. Can be `"default"` or `"disabled"`. See [Recover your instance](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-recover.html) for more details.
     */
    @JvmName("iiblpsvijgnhpveb")
    public suspend fun autoRecovery(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRecovery = mapped
    }

    internal fun build(): SpotInstanceRequestMaintenanceOptionsArgs =
        SpotInstanceRequestMaintenanceOptionsArgs(
            autoRecovery = autoRecovery,
        )
}
