@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.SpotInstanceRequestMetadataOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property httpEndpoint Whether the metadata service is available. Valid values include `enabled` or `disabled`. Defaults to `enabled`.
 * @property httpProtocolIpv6 Whether the IPv6 endpoint for the instance metadata service is enabled. Defaults to `disabled`.
 * @property httpPutResponseHopLimit Desired HTTP PUT response hop limit for instance metadata requests. The larger the number, the further instance metadata requests can travel. Valid values are integer from `1` to `64`. Defaults to `1`.
 * @property httpTokens Whether or not the metadata service requires session tokens, also referred to as _Instance Metadata Service Version 2 (IMDSv2)_. Valid values include `optional` or `required`. Defaults to `optional`.
 * @property instanceMetadataTags Enables or disables access to instance tags from the instance metadata service. Valid values include `enabled` or `disabled`. Defaults to `disabled`.
 * For more information, see the documentation on the [Instance Metadata Service](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html).
 */
public data class SpotInstanceRequestMetadataOptionsArgs(
    public val httpEndpoint: Output<String>? = null,
    public val httpProtocolIpv6: Output<String>? = null,
    public val httpPutResponseHopLimit: Output<Int>? = null,
    public val httpTokens: Output<String>? = null,
    public val instanceMetadataTags: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.SpotInstanceRequestMetadataOptionsArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.SpotInstanceRequestMetadataOptionsArgs =
        com.pulumi.aws.ec2.inputs.SpotInstanceRequestMetadataOptionsArgs.builder()
            .httpEndpoint(httpEndpoint?.applyValue({ args0 -> args0 }))
            .httpProtocolIpv6(httpProtocolIpv6?.applyValue({ args0 -> args0 }))
            .httpPutResponseHopLimit(httpPutResponseHopLimit?.applyValue({ args0 -> args0 }))
            .httpTokens(httpTokens?.applyValue({ args0 -> args0 }))
            .instanceMetadataTags(instanceMetadataTags?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SpotInstanceRequestMetadataOptionsArgs].
 */
@PulumiTagMarker
public class SpotInstanceRequestMetadataOptionsArgsBuilder internal constructor() {
    private var httpEndpoint: Output<String>? = null

    private var httpProtocolIpv6: Output<String>? = null

    private var httpPutResponseHopLimit: Output<Int>? = null

    private var httpTokens: Output<String>? = null

    private var instanceMetadataTags: Output<String>? = null

    /**
     * @param value Whether the metadata service is available. Valid values include `enabled` or `disabled`. Defaults to `enabled`.
     */
    @JvmName("ffprrownyhhilvxo")
    public suspend fun httpEndpoint(`value`: Output<String>) {
        this.httpEndpoint = value
    }

    /**
     * @param value Whether the IPv6 endpoint for the instance metadata service is enabled. Defaults to `disabled`.
     */
    @JvmName("arfgqujnakvquiac")
    public suspend fun httpProtocolIpv6(`value`: Output<String>) {
        this.httpProtocolIpv6 = value
    }

    /**
     * @param value Desired HTTP PUT response hop limit for instance metadata requests. The larger the number, the further instance metadata requests can travel. Valid values are integer from `1` to `64`. Defaults to `1`.
     */
    @JvmName("btgagiipdbtfmhkr")
    public suspend fun httpPutResponseHopLimit(`value`: Output<Int>) {
        this.httpPutResponseHopLimit = value
    }

    /**
     * @param value Whether or not the metadata service requires session tokens, also referred to as _Instance Metadata Service Version 2 (IMDSv2)_. Valid values include `optional` or `required`. Defaults to `optional`.
     */
    @JvmName("qcrddbiwaxnofbvu")
    public suspend fun httpTokens(`value`: Output<String>) {
        this.httpTokens = value
    }

    /**
     * @param value Enables or disables access to instance tags from the instance metadata service. Valid values include `enabled` or `disabled`. Defaults to `disabled`.
     * For more information, see the documentation on the [Instance Metadata Service](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html).
     */
    @JvmName("iwtixpbowwwrpsxk")
    public suspend fun instanceMetadataTags(`value`: Output<String>) {
        this.instanceMetadataTags = value
    }

    /**
     * @param value Whether the metadata service is available. Valid values include `enabled` or `disabled`. Defaults to `enabled`.
     */
    @JvmName("vhnkdktbsxeyjqbh")
    public suspend fun httpEndpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpEndpoint = mapped
    }

    /**
     * @param value Whether the IPv6 endpoint for the instance metadata service is enabled. Defaults to `disabled`.
     */
    @JvmName("dbuhndjtdlhfrhva")
    public suspend fun httpProtocolIpv6(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpProtocolIpv6 = mapped
    }

    /**
     * @param value Desired HTTP PUT response hop limit for instance metadata requests. The larger the number, the further instance metadata requests can travel. Valid values are integer from `1` to `64`. Defaults to `1`.
     */
    @JvmName("ptqxyjxfkxebeqcg")
    public suspend fun httpPutResponseHopLimit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpPutResponseHopLimit = mapped
    }

    /**
     * @param value Whether or not the metadata service requires session tokens, also referred to as _Instance Metadata Service Version 2 (IMDSv2)_. Valid values include `optional` or `required`. Defaults to `optional`.
     */
    @JvmName("cilyqtqdkbdfvhlu")
    public suspend fun httpTokens(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpTokens = mapped
    }

    /**
     * @param value Enables or disables access to instance tags from the instance metadata service. Valid values include `enabled` or `disabled`. Defaults to `disabled`.
     * For more information, see the documentation on the [Instance Metadata Service](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html).
     */
    @JvmName("rnijbpdtefwloyfd")
    public suspend fun instanceMetadataTags(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceMetadataTags = mapped
    }

    internal fun build(): SpotInstanceRequestMetadataOptionsArgs =
        SpotInstanceRequestMetadataOptionsArgs(
            httpEndpoint = httpEndpoint,
            httpProtocolIpv6 = httpProtocolIpv6,
            httpPutResponseHopLimit = httpPutResponseHopLimit,
            httpTokens = httpTokens,
            instanceMetadataTags = instanceMetadataTags,
        )
}
