@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.SpotInstanceRequestNetworkInterfaceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property deleteOnTermination Whether or not to delete the network interface on instance termination. Defaults to `false`. Currently, the only valid value is `false`, as this is only supported when creating new network interfaces when launching an instance.
 * @property deviceIndex Integer index of the network interface attachment. Limited by instance type.
 * @property networkCardIndex Integer index of the network card. Limited by instance type. The default index is `0`.
 * @property networkInterfaceId ID of the network interface to attach.
 */
public data class SpotInstanceRequestNetworkInterfaceArgs(
    public val deleteOnTermination: Output<Boolean>? = null,
    public val deviceIndex: Output<Int>,
    public val networkCardIndex: Output<Int>? = null,
    public val networkInterfaceId: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.SpotInstanceRequestNetworkInterfaceArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.SpotInstanceRequestNetworkInterfaceArgs =
        com.pulumi.aws.ec2.inputs.SpotInstanceRequestNetworkInterfaceArgs.builder()
            .deleteOnTermination(deleteOnTermination?.applyValue({ args0 -> args0 }))
            .deviceIndex(deviceIndex.applyValue({ args0 -> args0 }))
            .networkCardIndex(networkCardIndex?.applyValue({ args0 -> args0 }))
            .networkInterfaceId(networkInterfaceId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SpotInstanceRequestNetworkInterfaceArgs].
 */
@PulumiTagMarker
public class SpotInstanceRequestNetworkInterfaceArgsBuilder internal constructor() {
    private var deleteOnTermination: Output<Boolean>? = null

    private var deviceIndex: Output<Int>? = null

    private var networkCardIndex: Output<Int>? = null

    private var networkInterfaceId: Output<String>? = null

    /**
     * @param value Whether or not to delete the network interface on instance termination. Defaults to `false`. Currently, the only valid value is `false`, as this is only supported when creating new network interfaces when launching an instance.
     */
    @JvmName("yjomhgndcdqlaqjt")
    public suspend fun deleteOnTermination(`value`: Output<Boolean>) {
        this.deleteOnTermination = value
    }

    /**
     * @param value Integer index of the network interface attachment. Limited by instance type.
     */
    @JvmName("igbicdofnvmnjklm")
    public suspend fun deviceIndex(`value`: Output<Int>) {
        this.deviceIndex = value
    }

    /**
     * @param value Integer index of the network card. Limited by instance type. The default index is `0`.
     */
    @JvmName("fdiayqvbokvterhu")
    public suspend fun networkCardIndex(`value`: Output<Int>) {
        this.networkCardIndex = value
    }

    /**
     * @param value ID of the network interface to attach.
     */
    @JvmName("leeulucmahgiaeql")
    public suspend fun networkInterfaceId(`value`: Output<String>) {
        this.networkInterfaceId = value
    }

    /**
     * @param value Whether or not to delete the network interface on instance termination. Defaults to `false`. Currently, the only valid value is `false`, as this is only supported when creating new network interfaces when launching an instance.
     */
    @JvmName("jpqkoegufhfncnmj")
    public suspend fun deleteOnTermination(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteOnTermination = mapped
    }

    /**
     * @param value Integer index of the network interface attachment. Limited by instance type.
     */
    @JvmName("rxpnjmctqnbvwnbd")
    public suspend fun deviceIndex(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deviceIndex = mapped
    }

    /**
     * @param value Integer index of the network card. Limited by instance type. The default index is `0`.
     */
    @JvmName("ytjuahhmtqybckao")
    public suspend fun networkCardIndex(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkCardIndex = mapped
    }

    /**
     * @param value ID of the network interface to attach.
     */
    @JvmName("shufcvcouobqldiy")
    public suspend fun networkInterfaceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkInterfaceId = mapped
    }

    internal fun build(): SpotInstanceRequestNetworkInterfaceArgs =
        SpotInstanceRequestNetworkInterfaceArgs(
            deleteOnTermination = deleteOnTermination,
            deviceIndex = deviceIndex ?: throw PulumiNullFieldException("deviceIndex"),
            networkCardIndex = networkCardIndex,
            networkInterfaceId = networkInterfaceId ?: throw PulumiNullFieldException("networkInterfaceId"),
        )
}
