@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.SpotInstanceRequestRootBlockDeviceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property deleteOnTermination Whether the volume should be destroyed on instance termination. Defaults to `true`.
 * @property deviceName
 * @property encrypted Whether to enable volume encryption. Defaults to `false`. Must be configured to perform drift detection.
 * @property iops Amount of provisioned [IOPS](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-io-characteristics.html). Only valid for volume_type of `io1`, `io2` or `gp3`.
 * @property kmsKeyId Amazon Resource Name (ARN) of the KMS Key to use when encrypting the volume. Must be configured to perform drift detection.
 * @property tags Map of tags to assign to the device.
 * @property tagsAll A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
 * @property throughput Throughput to provision for a volume in mebibytes per second (MiB/s). This is only valid for `volume_type` of `gp3`.
 * @property volumeId
 * @property volumeSize Size of the volume in gibibytes (GiB).
 * @property volumeType Type of volume. Valid values include `standard`, `gp2`, `gp3`, `io1`, `io2`, `sc1`, or `st1`. Defaults to the volume type that the AMI uses.
 * Modifying the `encrypted` or `kms_key_id` settings of the `root_block_device` requires resource replacement.
 */
public data class SpotInstanceRequestRootBlockDeviceArgs(
    public val deleteOnTermination: Output<Boolean>? = null,
    public val deviceName: Output<String>? = null,
    public val encrypted: Output<Boolean>? = null,
    public val iops: Output<Int>? = null,
    public val kmsKeyId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val tagsAll: Output<Map<String, String>>? = null,
    public val throughput: Output<Int>? = null,
    public val volumeId: Output<String>? = null,
    public val volumeSize: Output<Int>? = null,
    public val volumeType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.SpotInstanceRequestRootBlockDeviceArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.SpotInstanceRequestRootBlockDeviceArgs =
        com.pulumi.aws.ec2.inputs.SpotInstanceRequestRootBlockDeviceArgs.builder()
            .deleteOnTermination(deleteOnTermination?.applyValue({ args0 -> args0 }))
            .deviceName(deviceName?.applyValue({ args0 -> args0 }))
            .encrypted(encrypted?.applyValue({ args0 -> args0 }))
            .iops(iops?.applyValue({ args0 -> args0 }))
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .tagsAll(tagsAll?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .throughput(throughput?.applyValue({ args0 -> args0 }))
            .volumeId(volumeId?.applyValue({ args0 -> args0 }))
            .volumeSize(volumeSize?.applyValue({ args0 -> args0 }))
            .volumeType(volumeType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SpotInstanceRequestRootBlockDeviceArgs].
 */
@PulumiTagMarker
public class SpotInstanceRequestRootBlockDeviceArgsBuilder internal constructor() {
    private var deleteOnTermination: Output<Boolean>? = null

    private var deviceName: Output<String>? = null

    private var encrypted: Output<Boolean>? = null

    private var iops: Output<Int>? = null

    private var kmsKeyId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var tagsAll: Output<Map<String, String>>? = null

    private var throughput: Output<Int>? = null

    private var volumeId: Output<String>? = null

    private var volumeSize: Output<Int>? = null

    private var volumeType: Output<String>? = null

    /**
     * @param value Whether the volume should be destroyed on instance termination. Defaults to `true`.
     */
    @JvmName("ybmbjjctchwkghct")
    public suspend fun deleteOnTermination(`value`: Output<Boolean>) {
        this.deleteOnTermination = value
    }

    /**
     * @param value
     */
    @JvmName("thehbtigqamlcopj")
    public suspend fun deviceName(`value`: Output<String>) {
        this.deviceName = value
    }

    /**
     * @param value Whether to enable volume encryption. Defaults to `false`. Must be configured to perform drift detection.
     */
    @JvmName("cyremfphdhaqtppt")
    public suspend fun encrypted(`value`: Output<Boolean>) {
        this.encrypted = value
    }

    /**
     * @param value Amount of provisioned [IOPS](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-io-characteristics.html). Only valid for volume_type of `io1`, `io2` or `gp3`.
     */
    @JvmName("djjhmfrbsqyxrqnr")
    public suspend fun iops(`value`: Output<Int>) {
        this.iops = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of the KMS Key to use when encrypting the volume. Must be configured to perform drift detection.
     */
    @JvmName("cmywngwkjigmyvhm")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value Map of tags to assign to the device.
     */
    @JvmName("febvgkihuoyalklv")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @JvmName("bpesbivhkpcxrawo")
    public suspend fun tagsAll(`value`: Output<Map<String, String>>) {
        this.tagsAll = value
    }

    /**
     * @param value Throughput to provision for a volume in mebibytes per second (MiB/s). This is only valid for `volume_type` of `gp3`.
     */
    @JvmName("hebrjvtjpfjyarld")
    public suspend fun throughput(`value`: Output<Int>) {
        this.throughput = value
    }

    /**
     * @param value
     */
    @JvmName("umcfoflqdhfqkowx")
    public suspend fun volumeId(`value`: Output<String>) {
        this.volumeId = value
    }

    /**
     * @param value Size of the volume in gibibytes (GiB).
     */
    @JvmName("luqnsmlqvepaqfip")
    public suspend fun volumeSize(`value`: Output<Int>) {
        this.volumeSize = value
    }

    /**
     * @param value Type of volume. Valid values include `standard`, `gp2`, `gp3`, `io1`, `io2`, `sc1`, or `st1`. Defaults to the volume type that the AMI uses.
     * Modifying the `encrypted` or `kms_key_id` settings of the `root_block_device` requires resource replacement.
     */
    @JvmName("xsgrgbwdrcrmmima")
    public suspend fun volumeType(`value`: Output<String>) {
        this.volumeType = value
    }

    /**
     * @param value Whether the volume should be destroyed on instance termination. Defaults to `true`.
     */
    @JvmName("syuckoaxwaadxwtm")
    public suspend fun deleteOnTermination(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteOnTermination = mapped
    }

    /**
     * @param value
     */
    @JvmName("nogkbjixxojoeccg")
    public suspend fun deviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceName = mapped
    }

    /**
     * @param value Whether to enable volume encryption. Defaults to `false`. Must be configured to perform drift detection.
     */
    @JvmName("abfdymvbxnpwxfyv")
    public suspend fun encrypted(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encrypted = mapped
    }

    /**
     * @param value Amount of provisioned [IOPS](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-io-characteristics.html). Only valid for volume_type of `io1`, `io2` or `gp3`.
     */
    @JvmName("qbrrwbwxnegntdec")
    public suspend fun iops(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iops = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of the KMS Key to use when encrypting the volume. Must be configured to perform drift detection.
     */
    @JvmName("urdveaaagimkknly")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value Map of tags to assign to the device.
     */
    @JvmName("yyniejsgbyfgexvd")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the device.
     */
    @JvmName("chftvlmrtleccrev")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @JvmName("acyexpupjrrncksf")
    public suspend fun tagsAll(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tagsAll = mapped
    }

    /**
     * @param values A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @JvmName("wtnijvedcwxexctd")
    public fun tagsAll(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tagsAll = mapped
    }

    /**
     * @param value Throughput to provision for a volume in mebibytes per second (MiB/s). This is only valid for `volume_type` of `gp3`.
     */
    @JvmName("synuvlhjtlukbdwc")
    public suspend fun throughput(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.throughput = mapped
    }

    /**
     * @param value
     */
    @JvmName("dfcyyvphqajnkccq")
    public suspend fun volumeId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeId = mapped
    }

    /**
     * @param value Size of the volume in gibibytes (GiB).
     */
    @JvmName("xrhlwhgrapeadlcv")
    public suspend fun volumeSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeSize = mapped
    }

    /**
     * @param value Type of volume. Valid values include `standard`, `gp2`, `gp3`, `io1`, `io2`, `sc1`, or `st1`. Defaults to the volume type that the AMI uses.
     * Modifying the `encrypted` or `kms_key_id` settings of the `root_block_device` requires resource replacement.
     */
    @JvmName("amcfnpnimreseglo")
    public suspend fun volumeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeType = mapped
    }

    internal fun build(): SpotInstanceRequestRootBlockDeviceArgs =
        SpotInstanceRequestRootBlockDeviceArgs(
            deleteOnTermination = deleteOnTermination,
            deviceName = deviceName,
            encrypted = encrypted,
            iops = iops,
            kmsKeyId = kmsKeyId,
            tags = tags,
            tagsAll = tagsAll,
            throughput = throughput,
            volumeId = volumeId,
            volumeSize = volumeSize,
            volumeType = volumeType,
        )
}
