@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.TrafficMirrorFilterRuleDestinationPortRangeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property fromPort Starting port of the range
 * @property toPort Ending port of the range
 */
public data class TrafficMirrorFilterRuleDestinationPortRangeArgs(
    public val fromPort: Output<Int>? = null,
    public val toPort: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.TrafficMirrorFilterRuleDestinationPortRangeArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.TrafficMirrorFilterRuleDestinationPortRangeArgs =
        com.pulumi.aws.ec2.inputs.TrafficMirrorFilterRuleDestinationPortRangeArgs.builder()
            .fromPort(fromPort?.applyValue({ args0 -> args0 }))
            .toPort(toPort?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TrafficMirrorFilterRuleDestinationPortRangeArgs].
 */
@PulumiTagMarker
public class TrafficMirrorFilterRuleDestinationPortRangeArgsBuilder internal constructor() {
    private var fromPort: Output<Int>? = null

    private var toPort: Output<Int>? = null

    /**
     * @param value Starting port of the range
     */
    @JvmName("qivtkpdtwipeusga")
    public suspend fun fromPort(`value`: Output<Int>) {
        this.fromPort = value
    }

    /**
     * @param value Ending port of the range
     */
    @JvmName("kukhxgjljbwdsxbh")
    public suspend fun toPort(`value`: Output<Int>) {
        this.toPort = value
    }

    /**
     * @param value Starting port of the range
     */
    @JvmName("kxkiauomsjopoals")
    public suspend fun fromPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fromPort = mapped
    }

    /**
     * @param value Ending port of the range
     */
    @JvmName("yycpdecwamkxayxk")
    public suspend fun toPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.toPort = mapped
    }

    internal fun build(): TrafficMirrorFilterRuleDestinationPortRangeArgs =
        TrafficMirrorFilterRuleDestinationPortRangeArgs(
            fromPort = fromPort,
            toPort = toPort,
        )
}
