@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.VpcEndpointSubnetConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property ipv4 The IPv4 address to assign to the endpoint network interface in the subnet. You must provide an IPv4 address if the VPC endpoint supports IPv4.
 * @property ipv6 The IPv6 address to assign to the endpoint network interface in the subnet. You must provide an IPv6 address if the VPC endpoint supports IPv6.
 * @property subnetId
 */
public data class VpcEndpointSubnetConfigurationArgs(
    public val ipv4: Output<String>? = null,
    public val ipv6: Output<String>? = null,
    public val subnetId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.VpcEndpointSubnetConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.VpcEndpointSubnetConfigurationArgs =
        com.pulumi.aws.ec2.inputs.VpcEndpointSubnetConfigurationArgs.builder()
            .ipv4(ipv4?.applyValue({ args0 -> args0 }))
            .ipv6(ipv6?.applyValue({ args0 -> args0 }))
            .subnetId(subnetId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VpcEndpointSubnetConfigurationArgs].
 */
@PulumiTagMarker
public class VpcEndpointSubnetConfigurationArgsBuilder internal constructor() {
    private var ipv4: Output<String>? = null

    private var ipv6: Output<String>? = null

    private var subnetId: Output<String>? = null

    /**
     * @param value The IPv4 address to assign to the endpoint network interface in the subnet. You must provide an IPv4 address if the VPC endpoint supports IPv4.
     */
    @JvmName("ygbgsfoyeatpuota")
    public suspend fun ipv4(`value`: Output<String>) {
        this.ipv4 = value
    }

    /**
     * @param value The IPv6 address to assign to the endpoint network interface in the subnet. You must provide an IPv6 address if the VPC endpoint supports IPv6.
     */
    @JvmName("wilbekcbkrlnrijv")
    public suspend fun ipv6(`value`: Output<String>) {
        this.ipv6 = value
    }

    /**
     * @param value
     */
    @JvmName("urdnknyusfiodapv")
    public suspend fun subnetId(`value`: Output<String>) {
        this.subnetId = value
    }

    /**
     * @param value The IPv4 address to assign to the endpoint network interface in the subnet. You must provide an IPv4 address if the VPC endpoint supports IPv4.
     */
    @JvmName("kvpwdtqcjnmoaalr")
    public suspend fun ipv4(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv4 = mapped
    }

    /**
     * @param value The IPv6 address to assign to the endpoint network interface in the subnet. You must provide an IPv6 address if the VPC endpoint supports IPv6.
     */
    @JvmName("kmqwarojjliqxmol")
    public suspend fun ipv6(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6 = mapped
    }

    /**
     * @param value
     */
    @JvmName("mjrkrqnopikbebes")
    public suspend fun subnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetId = mapped
    }

    internal fun build(): VpcEndpointSubnetConfigurationArgs = VpcEndpointSubnetConfigurationArgs(
        ipv4 = ipv4,
        ipv6 = ipv6,
        subnetId = subnetId,
    )
}
