@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.VpcPeeringConnectionRequesterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property allowRemoteVpcDnsResolution Allow a local VPC to resolve public DNS hostnames to
 * private IP addresses when queried from instances in the peer VPC.
 */
public data class VpcPeeringConnectionRequesterArgs(
    public val allowRemoteVpcDnsResolution: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.VpcPeeringConnectionRequesterArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.VpcPeeringConnectionRequesterArgs =
        com.pulumi.aws.ec2.inputs.VpcPeeringConnectionRequesterArgs.builder()
            .allowRemoteVpcDnsResolution(allowRemoteVpcDnsResolution?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VpcPeeringConnectionRequesterArgs].
 */
@PulumiTagMarker
public class VpcPeeringConnectionRequesterArgsBuilder internal constructor() {
    private var allowRemoteVpcDnsResolution: Output<Boolean>? = null

    /**
     * @param value Allow a local VPC to resolve public DNS hostnames to
     * private IP addresses when queried from instances in the peer VPC.
     */
    @JvmName("tinvkojlwifdbreq")
    public suspend fun allowRemoteVpcDnsResolution(`value`: Output<Boolean>) {
        this.allowRemoteVpcDnsResolution = value
    }

    /**
     * @param value Allow a local VPC to resolve public DNS hostnames to
     * private IP addresses when queried from instances in the peer VPC.
     */
    @JvmName("dywwiqekljonhokk")
    public suspend fun allowRemoteVpcDnsResolution(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowRemoteVpcDnsResolution = mapped
    }

    internal fun build(): VpcPeeringConnectionRequesterArgs = VpcPeeringConnectionRequesterArgs(
        allowRemoteVpcDnsResolution = allowRemoteVpcDnsResolution,
    )
}
