@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.VpnConnectionTunnel1LogOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property cloudwatchLogOptions Options for sending VPN tunnel logs to CloudWatch. See CloudWatch Log Options below for more details.
 */
public data class VpnConnectionTunnel1LogOptionsArgs(
    public val cloudwatchLogOptions: Output<VpnConnectionTunnel1LogOptionsCloudwatchLogOptionsArgs>? =
        null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.VpnConnectionTunnel1LogOptionsArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.VpnConnectionTunnel1LogOptionsArgs =
        com.pulumi.aws.ec2.inputs.VpnConnectionTunnel1LogOptionsArgs.builder()
            .cloudwatchLogOptions(
                cloudwatchLogOptions?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [VpnConnectionTunnel1LogOptionsArgs].
 */
@PulumiTagMarker
public class VpnConnectionTunnel1LogOptionsArgsBuilder internal constructor() {
    private var cloudwatchLogOptions: Output<VpnConnectionTunnel1LogOptionsCloudwatchLogOptionsArgs>? =
        null

    /**
     * @param value Options for sending VPN tunnel logs to CloudWatch. See CloudWatch Log Options below for more details.
     */
    @JvmName("rfijqrsaaxcfjueb")
    public suspend fun cloudwatchLogOptions(`value`: Output<VpnConnectionTunnel1LogOptionsCloudwatchLogOptionsArgs>) {
        this.cloudwatchLogOptions = value
    }

    /**
     * @param value Options for sending VPN tunnel logs to CloudWatch. See CloudWatch Log Options below for more details.
     */
    @JvmName("ifthvpkiseoqddyn")
    public suspend fun cloudwatchLogOptions(`value`: VpnConnectionTunnel1LogOptionsCloudwatchLogOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudwatchLogOptions = mapped
    }

    /**
     * @param argument Options for sending VPN tunnel logs to CloudWatch. See CloudWatch Log Options below for more details.
     */
    @JvmName("lougjjqylvbyfubo")
    public suspend fun cloudwatchLogOptions(argument: suspend VpnConnectionTunnel1LogOptionsCloudwatchLogOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = VpnConnectionTunnel1LogOptionsCloudwatchLogOptionsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.cloudwatchLogOptions = mapped
    }

    internal fun build(): VpnConnectionTunnel1LogOptionsArgs = VpnConnectionTunnel1LogOptionsArgs(
        cloudwatchLogOptions = cloudwatchLogOptions,
    )
}
