@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.VpnConnectionTunnel1LogOptionsCloudwatchLogOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property logEnabled Enable or disable VPN tunnel logging feature. The default is `false`.
 * @property logGroupArn The Amazon Resource Name (ARN) of the CloudWatch log group to send logs to.
 * @property logOutputFormat Set log format. Default format is json. Possible values are: `json` and `text`. The default is `json`.
 */
public data class VpnConnectionTunnel1LogOptionsCloudwatchLogOptionsArgs(
    public val logEnabled: Output<Boolean>? = null,
    public val logGroupArn: Output<String>? = null,
    public val logOutputFormat: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.ec2.inputs.VpnConnectionTunnel1LogOptionsCloudwatchLogOptionsArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.VpnConnectionTunnel1LogOptionsCloudwatchLogOptionsArgs =
        com.pulumi.aws.ec2.inputs.VpnConnectionTunnel1LogOptionsCloudwatchLogOptionsArgs.builder()
            .logEnabled(logEnabled?.applyValue({ args0 -> args0 }))
            .logGroupArn(logGroupArn?.applyValue({ args0 -> args0 }))
            .logOutputFormat(logOutputFormat?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VpnConnectionTunnel1LogOptionsCloudwatchLogOptionsArgs].
 */
@PulumiTagMarker
public class VpnConnectionTunnel1LogOptionsCloudwatchLogOptionsArgsBuilder internal constructor() {
    private var logEnabled: Output<Boolean>? = null

    private var logGroupArn: Output<String>? = null

    private var logOutputFormat: Output<String>? = null

    /**
     * @param value Enable or disable VPN tunnel logging feature. The default is `false`.
     */
    @JvmName("hmfgenpteiknjjgg")
    public suspend fun logEnabled(`value`: Output<Boolean>) {
        this.logEnabled = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the CloudWatch log group to send logs to.
     */
    @JvmName("ycyaqhdikwbuwiqq")
    public suspend fun logGroupArn(`value`: Output<String>) {
        this.logGroupArn = value
    }

    /**
     * @param value Set log format. Default format is json. Possible values are: `json` and `text`. The default is `json`.
     */
    @JvmName("dvgdyhsbedccqdcc")
    public suspend fun logOutputFormat(`value`: Output<String>) {
        this.logOutputFormat = value
    }

    /**
     * @param value Enable or disable VPN tunnel logging feature. The default is `false`.
     */
    @JvmName("pbtdwnxjaqjnsfju")
    public suspend fun logEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logEnabled = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the CloudWatch log group to send logs to.
     */
    @JvmName("wjujrwqvsscltddd")
    public suspend fun logGroupArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logGroupArn = mapped
    }

    /**
     * @param value Set log format. Default format is json. Possible values are: `json` and `text`. The default is `json`.
     */
    @JvmName("raaymlqmfyxjwgya")
    public suspend fun logOutputFormat(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logOutputFormat = mapped
    }

    internal fun build(): VpnConnectionTunnel1LogOptionsCloudwatchLogOptionsArgs =
        VpnConnectionTunnel1LogOptionsCloudwatchLogOptionsArgs(
            logEnabled = logEnabled,
            logGroupArn = logGroupArn,
            logOutputFormat = logOutputFormat,
        )
}
