@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.VpnConnectionTunnel2LogOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property cloudwatchLogOptions Options for sending VPN tunnel logs to CloudWatch. See CloudWatch Log Options below for more details.
 */
public data class VpnConnectionTunnel2LogOptionsArgs(
    public val cloudwatchLogOptions: Output<VpnConnectionTunnel2LogOptionsCloudwatchLogOptionsArgs>? =
        null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.VpnConnectionTunnel2LogOptionsArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.VpnConnectionTunnel2LogOptionsArgs =
        com.pulumi.aws.ec2.inputs.VpnConnectionTunnel2LogOptionsArgs.builder()
            .cloudwatchLogOptions(
                cloudwatchLogOptions?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [VpnConnectionTunnel2LogOptionsArgs].
 */
@PulumiTagMarker
public class VpnConnectionTunnel2LogOptionsArgsBuilder internal constructor() {
    private var cloudwatchLogOptions: Output<VpnConnectionTunnel2LogOptionsCloudwatchLogOptionsArgs>? =
        null

    /**
     * @param value Options for sending VPN tunnel logs to CloudWatch. See CloudWatch Log Options below for more details.
     */
    @JvmName("yfuqxeqxmtbcdnkg")
    public suspend fun cloudwatchLogOptions(`value`: Output<VpnConnectionTunnel2LogOptionsCloudwatchLogOptionsArgs>) {
        this.cloudwatchLogOptions = value
    }

    /**
     * @param value Options for sending VPN tunnel logs to CloudWatch. See CloudWatch Log Options below for more details.
     */
    @JvmName("hiljiwdxhtldtxtp")
    public suspend fun cloudwatchLogOptions(`value`: VpnConnectionTunnel2LogOptionsCloudwatchLogOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudwatchLogOptions = mapped
    }

    /**
     * @param argument Options for sending VPN tunnel logs to CloudWatch. See CloudWatch Log Options below for more details.
     */
    @JvmName("qjbfqmdvuphddxbj")
    public suspend fun cloudwatchLogOptions(argument: suspend VpnConnectionTunnel2LogOptionsCloudwatchLogOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = VpnConnectionTunnel2LogOptionsCloudwatchLogOptionsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.cloudwatchLogOptions = mapped
    }

    internal fun build(): VpnConnectionTunnel2LogOptionsArgs = VpnConnectionTunnel2LogOptionsArgs(
        cloudwatchLogOptions = cloudwatchLogOptions,
    )
}
