@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property deleteOnTermination Boolean controlling whether the EBS volumes created to
 * support each created instance will be deleted once that instance is terminated.
 * @property deviceName Path at which the device is exposed to created instances.
 * @property encrypted Boolean controlling whether the created EBS volumes will be encrypted. Can't be used with `snapshot_id`.
 * @property iops Number of I/O operations per second the
 * created volumes will support.
 * @property outpostArn ARN of the Outpost on which the snapshot is stored.
 * > **Note:** You can specify `encrypted` or `snapshot_id` but not both.
 * @property snapshotId ID of an EBS snapshot that will be used to initialize the created
 * EBS volumes. If set, the `volume_size` attribute must be at least as large as the referenced
 * snapshot.
 * @property throughput Throughput that the EBS volume supports, in MiB/s. Only valid for `volume_type` of `gp3`.
 * @property volumeSize Size of created volumes in GiB.
 * If `snapshot_id` is set and `volume_size` is omitted then the volume will have the same size
 * as the selected snapshot.
 * @property volumeType Type of EBS volume to create. Can be `standard`, `gp2`, `gp3`, `io1`, `io2`, `sc1` or `st1` (Default: `standard`).
 */
public data class AmiCopyEbsBlockDevice(
    public val deleteOnTermination: Boolean? = null,
    public val deviceName: String? = null,
    public val encrypted: Boolean? = null,
    public val iops: Int? = null,
    public val outpostArn: String? = null,
    public val snapshotId: String? = null,
    public val throughput: Int? = null,
    public val volumeSize: Int? = null,
    public val volumeType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.AmiCopyEbsBlockDevice): AmiCopyEbsBlockDevice = AmiCopyEbsBlockDevice(
            deleteOnTermination = javaType.deleteOnTermination().map({ args0 -> args0 }).orElse(null),
            deviceName = javaType.deviceName().map({ args0 -> args0 }).orElse(null),
            encrypted = javaType.encrypted().map({ args0 -> args0 }).orElse(null),
            iops = javaType.iops().map({ args0 -> args0 }).orElse(null),
            outpostArn = javaType.outpostArn().map({ args0 -> args0 }).orElse(null),
            snapshotId = javaType.snapshotId().map({ args0 -> args0 }).orElse(null),
            throughput = javaType.throughput().map({ args0 -> args0 }).orElse(null),
            volumeSize = javaType.volumeSize().map({ args0 -> args0 }).orElse(null),
            volumeType = javaType.volumeType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
