@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property deviceName Path at which the device is exposed to created instances.
 * @property virtualName Name for the ephemeral device, of the form "ephemeralN" where
 * *N* is a volume number starting from zero.
 */
public data class AmiCopyEphemeralBlockDevice(
    public val deviceName: String? = null,
    public val virtualName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.AmiCopyEphemeralBlockDevice): AmiCopyEphemeralBlockDevice = AmiCopyEphemeralBlockDevice(
            deviceName = javaType.deviceName().map({ args0 -> args0 }).orElse(null),
            virtualName = javaType.virtualName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
