@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property deviceName Path at which the device is exposed to created instances.
 * @property virtualName Name for the ephemeral device, of the form "ephemeralN" where
 * *N* is a volume number starting from zero.
 */
public data class AmiEphemeralBlockDevice(
    public val deviceName: String,
    public val virtualName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.AmiEphemeralBlockDevice): AmiEphemeralBlockDevice = AmiEphemeralBlockDevice(
            deviceName = javaType.deviceName(),
            virtualName = javaType.virtualName(),
        )
    }
}
