@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property action The action to take.
 * @property cidrBlock The CIDR block to match. This must be a valid network mask.
 * @property fromPort The from port to match.
 * @property icmpCode The ICMP type code to be used. Default 0.
 * @property icmpType The ICMP type to be used. Default 0.
 * @property ipv6CidrBlock The IPv6 CIDR block.
 * > For more information on ICMP types and codes, see [Internet Control Message Protocol (ICMP) Parameters](https://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml).
 * @property protocol The protocol to match. If using the -1 'all' protocol, you must specify a from and to port of 0.
 * @property ruleNo The rule number. Used for ordering.
 * @property toPort The to port to match.
 * The following arguments are optional:
 */
public data class DefaultNetworkAclIngress(
    public val action: String,
    public val cidrBlock: String? = null,
    public val fromPort: Int,
    public val icmpCode: Int? = null,
    public val icmpType: Int? = null,
    public val ipv6CidrBlock: String? = null,
    public val protocol: String,
    public val ruleNo: Int,
    public val toPort: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.DefaultNetworkAclIngress): DefaultNetworkAclIngress = DefaultNetworkAclIngress(
            action = javaType.action(),
            cidrBlock = javaType.cidrBlock().map({ args0 -> args0 }).orElse(null),
            fromPort = javaType.fromPort(),
            icmpCode = javaType.icmpCode().map({ args0 -> args0 }).orElse(null),
            icmpType = javaType.icmpType().map({ args0 -> args0 }).orElse(null),
            ipv6CidrBlock = javaType.ipv6CidrBlock().map({ args0 -> args0 }).orElse(null),
            protocol = javaType.protocol(),
            ruleNo = javaType.ruleNo(),
            toPort = javaType.toPort(),
        )
    }
}
