@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property launchTemplateSpecification Nested argument containing EC2 Launch Template to use. Defined below.
 * @property overrides Nested argument(s) containing parameters to override the same parameters in the Launch Template. Defined below.
 */
public data class FleetLaunchTemplateConfig(
    public val launchTemplateSpecification: FleetLaunchTemplateConfigLaunchTemplateSpecification? =
        null,
    public val overrides: List<FleetLaunchTemplateConfigOverride>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.FleetLaunchTemplateConfig): FleetLaunchTemplateConfig = FleetLaunchTemplateConfig(
            launchTemplateSpecification = javaType.launchTemplateSpecification().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.FleetLaunchTemplateConfigLaunchTemplateSpecification.Companion.toKotlin(args0)
                })
            }).orElse(null),
            overrides = javaType.overrides().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ec2.kotlin.outputs.FleetLaunchTemplateConfigOverride.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
