@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property launchTemplateId The ID of the launch template.
 * @property launchTemplateName The name of the launch template.
 * @property version The launch template version number, `$Latest`, or `$Default.`
 */
public data class FleetLaunchTemplateConfigLaunchTemplateSpecification(
    public val launchTemplateId: String? = null,
    public val launchTemplateName: String? = null,
    public val version: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.FleetLaunchTemplateConfigLaunchTemplateSpecification): FleetLaunchTemplateConfigLaunchTemplateSpecification =
            FleetLaunchTemplateConfigLaunchTemplateSpecification(
                launchTemplateId = javaType.launchTemplateId().map({ args0 -> args0 }).orElse(null),
                launchTemplateName = javaType.launchTemplateName().map({ args0 -> args0 }).orElse(null),
                version = javaType.version(),
            )
    }
}
