@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property usageStrategy Indicates whether to use unused Capacity Reservations for fulfilling On-Demand capacity. Valid values: `use-capacity-reservations-first`.
 */
public data class FleetOnDemandOptionsCapacityReservationOptions(
    public val usageStrategy: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.FleetOnDemandOptionsCapacityReservationOptions): FleetOnDemandOptionsCapacityReservationOptions =
            FleetOnDemandOptionsCapacityReservationOptions(
                usageStrategy = javaType.usageStrategy().map({ args0 -> args0 }).orElse(null),
            )
    }
}
