@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property allocationStrategy How to allocate the target capacity across the Spot pools. Valid values: `diversified`, `lowestPrice`, `capacity-optimized`, `capacity-optimized-prioritized` and `price-capacity-optimized`. Default: `lowestPrice`.
 * @property instanceInterruptionBehavior Behavior when a Spot Instance is interrupted. Valid values: `hibernate`, `stop`, `terminate`. Default: `terminate`.
 * @property instancePoolsToUseCount Number of Spot pools across which to allocate your target Spot capacity. Valid only when Spot `allocation_strategy` is set to `lowestPrice`. Default: `1`.
 * @property maintenanceStrategies Nested argument containing maintenance strategies for managing your Spot Instances that are at an elevated risk of being interrupted. Defined below.
 */
public data class FleetSpotOptions(
    public val allocationStrategy: String? = null,
    public val instanceInterruptionBehavior: String? = null,
    public val instancePoolsToUseCount: Int? = null,
    public val maintenanceStrategies: FleetSpotOptionsMaintenanceStrategies? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.FleetSpotOptions): FleetSpotOptions =
            FleetSpotOptions(
                allocationStrategy = javaType.allocationStrategy().map({ args0 -> args0 }).orElse(null),
                instanceInterruptionBehavior = javaType.instanceInterruptionBehavior().map({ args0 ->
                    args0
                }).orElse(null),
                instancePoolsToUseCount = javaType.instancePoolsToUseCount().map({ args0 -> args0 }).orElse(null),
                maintenanceStrategies = javaType.maintenanceStrategies().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ec2.kotlin.outputs.FleetSpotOptionsMaintenanceStrategies.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
