@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property defaultTargetCapacityType Default target capacity type. Valid values: `on-demand`, `spot`.
 * @property onDemandTargetCapacity The number of On-Demand units to request.
 * @property spotTargetCapacity The number of Spot units to request.
 * @property targetCapacityUnitType The unit for the target capacity.
 * If you specify `target_capacity_unit_type`, `instance_requirements` must be specified.
 * @property totalTargetCapacity The number of units to request, filled using `default_target_capacity_type`.
 */
public data class FleetTargetCapacitySpecification(
    public val defaultTargetCapacityType: String,
    public val onDemandTargetCapacity: Int? = null,
    public val spotTargetCapacity: Int? = null,
    public val targetCapacityUnitType: String? = null,
    public val totalTargetCapacity: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.FleetTargetCapacitySpecification): FleetTargetCapacitySpecification = FleetTargetCapacitySpecification(
            defaultTargetCapacityType = javaType.defaultTargetCapacityType(),
            onDemandTargetCapacity = javaType.onDemandTargetCapacity().map({ args0 -> args0 }).orElse(null),
            spotTargetCapacity = javaType.spotTargetCapacity().map({ args0 -> args0 }).orElse(null),
            targetCapacityUnitType = javaType.targetCapacityUnitType().map({ args0 -> args0 }).orElse(null),
            totalTargetCapacity = javaType.totalTargetCapacity(),
        )
    }
}
