@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property fileFormat The format for the flow log. Default value: `plain-text`. Valid values: `plain-text`, `parquet`.
 * @property hiveCompatiblePartitions Indicates whether to use Hive-compatible prefixes for flow logs stored in Amazon S3. Default value: `false`.
 * @property perHourPartition Indicates whether to partition the flow log per hour. This reduces the cost and response time for queries. Default value: `false`.
 */
public data class FlowLogDestinationOptions(
    public val fileFormat: String? = null,
    public val hiveCompatiblePartitions: Boolean? = null,
    public val perHourPartition: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.FlowLogDestinationOptions): FlowLogDestinationOptions = FlowLogDestinationOptions(
            fileFormat = javaType.fileFormat().map({ args0 -> args0 }).orElse(null),
            hiveCompatiblePartitions = javaType.hiveCompatiblePartitions().map({ args0 -> args0 }).orElse(null),
            perHourPartition = javaType.perHourPartition().map({ args0 -> args0 }).orElse(null),
        )
    }
}
