@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getAmiIds.
 * @property executableUsers
 * @property filters
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property includeDeprecated
 * @property nameRegex
 * @property owners
 * @property sortAscending
 */
public data class GetAmiIdsResult(
    public val executableUsers: List<String>? = null,
    public val filters: List<GetAmiIdsFilter>? = null,
    public val id: String,
    public val ids: List<String>,
    public val includeDeprecated: Boolean? = null,
    public val nameRegex: String? = null,
    public val owners: List<String>,
    public val sortAscending: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetAmiIdsResult): GetAmiIdsResult =
            GetAmiIdsResult(
                executableUsers = javaType.executableUsers().map({ args0 -> args0 }),
                filters = javaType.filters().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ec2.kotlin.outputs.GetAmiIdsFilter.Companion.toKotlin(args0)
                    })
                }),
                id = javaType.id(),
                ids = javaType.ids().map({ args0 -> args0 }),
                includeDeprecated = javaType.includeDeprecated().map({ args0 -> args0 }).orElse(null),
                nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
                owners = javaType.owners().map({ args0 -> args0 }),
                sortAscending = javaType.sortAscending().map({ args0 -> args0 }).orElse(null),
            )
    }
}
