@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getAmi.
 * @property architecture OS architecture of the AMI (ie: `i386` or `x86_64`).
 * @property arn ARN of the AMI.
 * @property blockDeviceMappings Set of objects with block device mappings of the AMI.
 * @property bootMode Boot mode of the image.
 * @property creationDate Date and time the image was created.
 * @property deprecationTime Date and time when the image will be deprecated.
 * @property description Description of the AMI that was provided during image
 * creation.
 * @property enaSupport Whether enhanced networking with ENA is enabled.
 * @property executableUsers
 * @property filters
 * @property hypervisor Hypervisor type of the image.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property imageId ID of the AMI. Should be the same as the resource `id`.
 * @property imageLocation Location of the AMI.
 * @property imageOwnerAlias AWS account alias (for example, `amazon`, `self`) or
 * the AWS account ID of the AMI owner.
 * @property imageType Type of image.
 * @property imdsSupport Instance Metadata Service (IMDS) support mode for the image. Set to `v2.0` if instances ran from this image enforce IMDSv2.
 * @property includeDeprecated
 * @property kernelId Kernel associated with the image, if any. Only applicable
 * for machine images.
 * @property mostRecent
 * @property name Name of the AMI that was provided during image creation.
 * @property nameRegex
 * @property ownerId AWS account ID of the image owner.
 * @property owners
 * @property platform Value is Windows for `Windows` AMIs; otherwise blank.
 * @property platformDetails Platform details associated with the billing code of the AMI.
 * @property productCodes Any product codes associated with the AMI.
 * * `product_codes.#.product_code_id` - The product code.
 * * `product_codes.#.product_code_type` - The type of product code.
 * @property public `true` if the image has public launch permissions.
 * @property ramdiskId RAM disk associated with the image, if any. Only applicable
 * for machine images.
 * @property rootDeviceName Device name of the root device.
 * @property rootDeviceType Type of root device (ie: `ebs` or `instance-store`).
 * @property rootSnapshotId Snapshot id associated with the root device, if any
 * (only applies to `ebs` root devices).
 * @property sriovNetSupport Whether enhanced networking is enabled.
 * @property state Current state of the AMI. If the state is `available`, the image
 * is successfully registered and can be used to launch an instance.
 * @property stateReason Describes a state change. Fields are `UNSET` if not available.
 * @property tags Any tags assigned to the image.
 * * `tags.#.key` - Key name of the tag.
 * * `tags.#.value` - Value of the tag.
 * @property tpmSupport If the image is configured for NitroTPM support, the value is `v2.0`.
 * @property usageOperation Operation of the Amazon EC2 instance and the billing code that is associated with the AMI.
 * @property virtualizationType Type of virtualization of the AMI (ie: `hvm` or
 * `paravirtual`).
 */
public data class GetAmiResult(
    public val architecture: String,
    public val arn: String,
    public val blockDeviceMappings: List<GetAmiBlockDeviceMapping>,
    public val bootMode: String,
    public val creationDate: String,
    public val deprecationTime: String,
    public val description: String,
    public val enaSupport: Boolean,
    public val executableUsers: List<String>? = null,
    public val filters: List<GetAmiFilter>? = null,
    public val hypervisor: String,
    public val id: String,
    public val imageId: String,
    public val imageLocation: String,
    public val imageOwnerAlias: String,
    public val imageType: String,
    public val imdsSupport: String,
    public val includeDeprecated: Boolean? = null,
    public val kernelId: String,
    public val mostRecent: Boolean? = null,
    public val name: String,
    public val nameRegex: String? = null,
    public val ownerId: String,
    public val owners: List<String>? = null,
    public val platform: String,
    public val platformDetails: String,
    public val productCodes: List<GetAmiProductCode>,
    public val `public`: Boolean,
    public val ramdiskId: String,
    public val rootDeviceName: String,
    public val rootDeviceType: String,
    public val rootSnapshotId: String,
    public val sriovNetSupport: String,
    public val state: String,
    public val stateReason: Map<String, String>,
    public val tags: Map<String, String>,
    public val tpmSupport: String,
    public val usageOperation: String,
    public val virtualizationType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ec2.outputs.GetAmiResult): GetAmiResult =
            GetAmiResult(
                architecture = javaType.architecture(),
                arn = javaType.arn(),
                blockDeviceMappings = javaType.blockDeviceMappings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ec2.kotlin.outputs.GetAmiBlockDeviceMapping.Companion.toKotlin(args0)
                    })
                }),
                bootMode = javaType.bootMode(),
                creationDate = javaType.creationDate(),
                deprecationTime = javaType.deprecationTime(),
                description = javaType.description(),
                enaSupport = javaType.enaSupport(),
                executableUsers = javaType.executableUsers().map({ args0 -> args0 }),
                filters = javaType.filters().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ec2.kotlin.outputs.GetAmiFilter.Companion.toKotlin(args0)
                    })
                }),
                hypervisor = javaType.hypervisor(),
                id = javaType.id(),
                imageId = javaType.imageId(),
                imageLocation = javaType.imageLocation(),
                imageOwnerAlias = javaType.imageOwnerAlias(),
                imageType = javaType.imageType(),
                imdsSupport = javaType.imdsSupport(),
                includeDeprecated = javaType.includeDeprecated().map({ args0 -> args0 }).orElse(null),
                kernelId = javaType.kernelId(),
                mostRecent = javaType.mostRecent().map({ args0 -> args0 }).orElse(null),
                name = javaType.name(),
                nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
                ownerId = javaType.ownerId(),
                owners = javaType.owners().map({ args0 -> args0 }),
                platform = javaType.platform(),
                platformDetails = javaType.platformDetails(),
                productCodes = javaType.productCodes().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ec2.kotlin.outputs.GetAmiProductCode.Companion.toKotlin(args0)
                    })
                }),
                `public` = javaType.public_(),
                ramdiskId = javaType.ramdiskId(),
                rootDeviceName = javaType.rootDeviceName(),
                rootDeviceType = javaType.rootDeviceType(),
                rootSnapshotId = javaType.rootSnapshotId(),
                sriovNetSupport = javaType.sriovNetSupport(),
                state = javaType.state(),
                stateReason = javaType.stateReason().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                tpmSupport = javaType.tpmSupport(),
                usageOperation = javaType.usageOperation(),
                virtualizationType = javaType.virtualizationType(),
            )
    }
}
